const fs = require("fs");
const path = require("path");
const hre = require("hardhat");

const DEPLOY_FILE = path.join(__dirname, "deploy.json");

async function deploy() {
    const token = await hre.ethers.getContractFactory(
        "TestToken"
    );
    const tokenA = await token.deploy("Test Token Ali", "TTA");
    await tokenA.waitForDeployment();
    const tokenAAddr = await tokenA.getAddress();

    const tokenB = await token.deploy("Test Token Bob", "TTB");
    await tokenB.waitForDeployment();
    const tokenBAddr = await tokenB.getAddress();

    // Deploy the contract
    const factory =  await hre.ethers.getContractFactory(
        "Bridge"
    );
    [owner] = await hre.ethers.getSigners();

    const contract = await factory.deploy(owner.address);
    await contract.waitForDeployment();
    const bridgeAddr = await contract.getAddress();

    const chainId = await hre.ethers.provider.getNetwork().then(network => network.chainId);
    await saveDeployment(chainId, tokenAAddr, tokenBAddr, bridgeAddr);
    console.log("initial_height = ", contract.deploymentTransaction().blockNumber)
    console.log("bridge_contract = ", bridgeAddr)
}

function saveDeployment(chainId, tokenA, tokenB, bridge) {
    let deployData = {};
    if (fs.existsSync(DEPLOY_FILE)) {
        deployData = JSON.parse(fs.readFileSync(DEPLOY_FILE, "utf8"));
    }

    deployData[chainId] = {
        tokenA,
        tokenB,
        bridge,
    };

    fs.writeFileSync(DEPLOY_FILE, JSON.stringify(deployData, null, 2));
    console.log("Deployment at chain ", chainId, " saved to deploy.json");
}

// Define the script
async function main() {
    await deploy();
}

// Run the script
main().catch((error) => {
    console.error("Error:", error);
});