const fs = require("fs");
const path = require("path");
const hre = require("hardhat");

var users = [
    "0xCb7559B648eE663A2B0C569837F510D5f0ABAaD1"
]

const DEPLOY_FILE = path.join(__dirname, "deploy.json");


async function mintToken(tokenA, tokenB, user) {
    var amount =  hre.ethers.parseEther("1000")
    var tx = await tokenA.mint(user, amount);
    await tx.wait();
    console.log("Minted TTA to user:", user, " amount:", hre.ethers.formatEther(amount));
    tx = await tokenB.mint(user, amount);
    await tx.wait();
    console.log("Minted TTB to user:", user, " amount:", hre.ethers.formatEther(amount));
}

async function getDeploy(chainId) {
    if (!fs.existsSync(DEPLOY_FILE)) {
        throw new Error("deploy.json file not found");
    }

    const deployData = JSON.parse(fs.readFileSync(DEPLOY_FILE, "utf8"));
    if (!deployData[chainId]) {
        throw new Error(`No deployment data found for chainId ${chainId}`);
    }

    const addrs = deployData[chainId];
    const tokenA = await hre.ethers.getContractAt("TestToken", addrs.tokenA);
    const tokenB = await hre.ethers.getContractAt("TestToken", addrs.tokenB);
    const bridge = await hre.ethers.getContractAt("Bridge", addrs.bridge);

    return {tokenA, tokenB, bridge}
}


// Define the script
async function main() {
    const chainId = await hre.ethers.provider.getNetwork().then(network => network.chainId);
    const targetChainId = chainId === 6174n ? 8891 : 6174;
    console.log("Current chain ID:", chainId, "Target chain ID:", targetChainId);

    const curChainDeploy = await getDeploy(chainId);
    for (var i = 0; i < users.length; i++) {
        await mintToken(curChainDeploy.tokenA, curChainDeploy.tokenB, users[i]);
    }
}

// Run the script
main().catch((error) => {
    console.error("Error:", error);
});