const fs = require("fs");
const path = require("path");
const hre = require("hardhat");

let INITIAL_VALIDATORS = process.env.BRIDGE_VALIDATORS
let TREASURY = process.env.TREASURY

const DEPLOY_FILE = path.join(__dirname, "deploy.json");
async function getOutConfig(bridge, token , targetchain) {
    const config = await bridge.outConfiguration(token, targetchain)
    console.log("OutConfig for token:", token, " to chain:", targetchain, " config:", config)
}

async function getDeploy(chainId) {
    if (!fs.existsSync(DEPLOY_FILE)) {
        throw new Error("deploy.json file not found");
    }

    const deployData = JSON.parse(fs.readFileSync(DEPLOY_FILE, "utf8"));
    if (!deployData[chainId]) {
        throw new Error(`No deployment data found for chainId ${chainId}`);
    }

    const addrs = deployData[chainId];
    const tokenA = await hre.ethers.getContractAt("TestToken", addrs.tokenA);
    const tokenB = await hre.ethers.getContractAt("TestToken", addrs.tokenB);
    const bridge = await hre.ethers.getContractAt("Bridge", addrs.bridge);

    return {tokenA, tokenB, bridge}
}


// Define the script
async function main() {
    const chainId = await hre.ethers.provider.getNetwork().then(network => network.chainId);
    const targetChainId = chainId === 6174n ? 8891 : 6174;
    console.log("Current chain ID:", chainId, "Target chain ID:", targetChainId);

    const curChainDeploy = await getDeploy(chainId);

    await getOutConfig(curChainDeploy.bridge, await curChainDeploy.tokenA.getAddress(), targetChainId);
}

// Run the script
main().catch((error) => {
    console.error("Error:", error);
});