# 区块链水龙头性能测试工具

这是一个用于测试区块链水龙头性能的命令行工具，使用 Golang 开发。该工具可以：

1. 随机生成以太坊地址以获取测试币
2. 指定总的测试时间
3. 指定每分钟的请求数
4. 跟踪交易回执状态，以确认请求成功率

## 功能特点

- 随机生成以太坊地址
- 可配置的测试持续时间
- 可配置的请求速率（支持最小/最大请求范围内的随机调整）
- 自动查询交易回执以确认交易状态
- 详细的性能统计（成功率、延迟等）
- 优雅的中断处理（支持 Ctrl+C 提前结束测试）

## 安装

确保已安装 Go 环境（推荐 Go 1.21 或更高版本），然后执行：

```bash
git clone <repository-url>
cd faucet
go mod tidy
```

## 使用方法

### 基本用法

```bash
go run main.go
```

这将使用默认参数运行测试：
- 测试时间：1分钟
- 每分钟请求数范围：60-60（固定值）
- 水龙头URL：https://faucet.mars.movachain.com/api/faucet/v1/transfer
- 令牌：5cd5c5c18f27acae

### 自定义参数

```bash
go run main.go -duration=5 -min-rpm=30 -max-rpm=100 -url="https://faucet.example.com/api" -token="your-token" -tx-url="https://example.com/api/tx"
```

### 参数说明

| 参数 | 说明 | 默认值 |
|------|------|--------|
| `-duration` | 测试持续时间（分钟） | 1 |
| `-min-rpm` | 最小每分钟请求数 | 60 |
| `-max-rpm` | 最大每分钟请求数 | 60 |
| `-url` | 水龙头API URL | https://faucet.mars.movachain.com/api/faucet/v1/transfer |
| `-token` | 水龙头API令牌 | 5cd5c5c18f27acae |
| `-tx-url` | 区块链RPC端点URL | https://mars.rpc.movachain.com |

## 输出示例

```
开始测试水龙头性能:
- 测试时间: 1 分钟
- 每分钟请求数范围: 60-60
- 水龙头URL: https://faucet.mars.movachain.com/api/faucet/v1/transfer
- 交易回执URL: https://mars.movachain.com/api/v1/jsonrpc

测试开始，按Ctrl+C可以提前结束测试
已完成 60 个请求

测试完成，结果统计:
- 总请求数: 60
- 成功请求数: 58 (96.67%)
- 失败请求数: 1 (1.67%)
- 待处理请求数: 1 (1.67%)
- 平均延迟: 2.5s
- 最大延迟: 4.2s
- 最小延迟: 1.8s
```

## 构建可执行文件

```bash
go build -o faucet-tester
```

然后可以直接运行可执行文件：

```bash
./faucet-tester -duration=5 -min-rpm=30 -max-rpm=100
```
