require("@nomicfoundation/hardhat-toolbox");
// dotenv
require("dotenv").config();

/** @type import('hardhat/config').HardhatUserConfig */
module.exports = {
  solidity: {
    compilers: [
      {
        version: "0.5.16",
        evmVersion: "istanbul",
        settings: {
          optimizer: {
            enabled: true,
            runs: 200,
          },
        },
      },
      {
        version: "0.6.6",
        evmVersion: "istanbul",
        settings: {
          optimizer: {
            enabled: true,
            runs: 200,
          },
        },
      },
      {
        version: "0.4.18",
        settings: {
          optimizer: {
            enabled: true,
            runs: 200,
          },
        },
      },
    ],
  },
  networks: {
    movatest: {
      url: "https://mars.rpc.movachain.com",
      accounts: [process.env.DEPLOYER_KEY_MOVASWAP],
    }
  },
  blockscout: {
    apiKey: "1",
    enabled: true,
    customChains: [
      {
        network: "movatest",
        chainId: 10323,
        urls: {
          apiURL: "https://scan.mars.movachain.com/api?chain=10323",
          browserURL: "https://scan.mars.movachain.com",
        },
      },
    ],
  },
  etherscan: {
    enabled: false
  },
  sourcify: {
    enabled: false
  }
};
