package constant

const JwtSecret = "uEj7AgDNCREwsvnTaCEtzDXt0I5eFDl8"

const (
	InvalidParam        = "invalid param"
	UnsupportedPlatform = "unsupported platform"
	InternalError       = "internal error"
)

const (
	TransferChainNoProcess   = 0
	TransferChainWaitConfirm = 1
	TransferChainExecuted    = 2
	TransferChainRejected    = 3
)

const (
	ValidatorStatusNoPrecess    = 0
	ValidatorStatusConfirmation = 1
	ValidatorStatusRejection    = 2
	ValidatorStatusFailure      = 3
)

const (
	EVENT_TRANSFER_OUT             = "TransferOut"
	EVENT_TRANSFER_IN              = "TransferIn"
	EVENT_TRANSFER_IN_CONFIRMATION = "TransferInConfirmation"
	EVENT_TRANSFER_IN_REJECTION    = "TransferInRejection"
	EVENT_TRANSFER_IN_EXECUTION    = "TransferInExecution"
)

type ValidatorOp int

func (op ValidatorOp) String() string {
	switch op {
	case ValidatorStatusConfirmation:
		return "TransferInConfirmation"
	case ValidatorStatusRejection:
		return "TransferInRejection"
	default:
		return "Unknown"
	}
}
