package dao

import (
	dbModel "code.wuban.net.cn/movabridge/token-bridge/model/db"
	"gorm.io/gorm"
	"gorm.io/gorm/clause"
	"gorm.io/gorm/logger"
)

// GetStorageHeight 获取上次缓存的高度
func (d *Dao) GetStorageHeight(key string) (value int64, err error) {
	storage := new(dbModel.Height)
	err = d.db.Model(storage).Where("`key` = ?", key).First(storage).Error
	if err == gorm.ErrRecordNotFound {
		return 0, ErrRecordNotFound
	}
	return storage.IntValue, err
}

// SetStorageHeight 设置上次缓存的高度
func (d *Dao) SetStorageHeight(key string, intValue int64) (err error) {
	tx := d.db.Session(&gorm.Session{Logger: d.db.Logger.LogMode(logger.Error)})
	return tx.Model(&dbModel.Height{}).Clauses(clause.OnConflict{UpdateAll: true}).Create(&dbModel.Height{
		Key:      key,
		IntValue: intValue,
	}).Error
}

func (d *Dao) GetUnprocessedBridgeEvents(limit int, offset int) (events []*dbModel.BridgeEvent, err error) {
	err = d.db.Model(&dbModel.BridgeEvent{}).
		Where("`from_chain_tx_hash` != '' AND `to_chain_status` < ? AND `validator_status` = ?", 2, 0).
		Order("created_at ASC").
		Limit(limit).
		Offset(offset).
		Find(&events).Error
	if err == gorm.ErrRecordNotFound {
		return nil, ErrRecordNotFound
	}
	return events, err
}

//	func (d *Dao) CreateBridgeEvent(event *dbModel.BridgeEvent) (err error) {
//		return d.db.Clauses(clause.OnConflict{DoNothing: true}).Create(event).Error
//	}
//
//	func (d *Dao) GetBridgeEventWithOutInfo(fromChain int64, outId int64) (event *dbModel.BridgeEvent, err error) {
//		event = new(dbModel.BridgeEvent)
//		err = d.db.Model(event).Where("`from_chain` = ? AND `out_id` = ?", fromChain, outId).First(event).Error
//		if err == gorm.ErrRecordNotFound {
//			return nil, ErrRecordNotFound
//		}
//		return event, err
//	}
//
//	func (d *Dao) GetBridgeEventWithInInfo(chain int64, inId int64) (event *dbModel.BridgeEvent, err error) {
//		event = new(dbModel.BridgeEvent)
//		err = d.db.Model(event).Where("`to_chain` = ? AND `in_id` = ?", chain, inId).First(event).Error
//		if err == gorm.ErrRecordNotFound {
//			return nil, ErrRecordNotFound
//		}
//		return event, err
//	}
//
//	func (d *Dao) UpdateBridgeWithTransferIn(event *dbModel.BridgeEvent) (err error) {
//		return d.db.Model(event).Where("`id` = ?", event.ID).Updates(map[string]interface{}{
//			"to_contract":      event.ToContract,
//			"in_timestamp":     event.InTimestamp,
//			"in_id":            event.InId,
//			"to_chain_tx_hash": event.ToChainTxHash,
//			"to_chain_status":  event.ToChainStatus,
//		}).Error
//	}
//
//	func (d *Dao) UpdateBridgeResult(event *dbModel.BridgeEvent, toChainHash string, status int) (err error) {
//		return d.db.Model(&dbModel.BridgeEvent{}).Where("`id` = ?", event.ID).Updates(map[string]interface{}{
//			"to_chain_status": status,
//			"finish_tx_hash":  toChainHash,
//		}).Error
//	}
func (d *Dao) UpdateBridgeValidatorOperation(event *dbModel.BridgeEvent, op int) (err error) {
	return d.db.Model(&dbModel.BridgeEvent{}).Where("`id` = ?", event.ID).Updates(map[string]interface{}{
		"validator_status": op,
	}).Error
}

//
//func (d *Dao) CreateValidatorEvent(hash string, chain int64, validator string, txHash string, eventType string, transferInId int64) (err error) {
//	event := &dbModel.ValidatorEvent{
//		ChainId:      chain,
//		Validator:    validator,
//		TxHash:       txHash,
//		Event:        eventType,
//		TransferInId: transferInId,
//		Hash:         hash,
//	}
//	return d.db.Clauses(clause.OnConflict{DoNothing: true}).Create(event).Error
//}
