package encpk

import (
	"encoding/hex"
	"fmt"
	"os"
	"testing"
)

func TestDecryptOTP(t *testing.T) {
	otpkey, err := os.ReadFile("../val.otp")
	if err != nil {
		t.Fatal("Failed to read key file:", err)
	}

	aeskey, err := os.ReadFile("../aes.key")
	if err != nil {
		t.Fatal("Failed to read AES key file:", err)
	}
	aeskeyData, _ := hex.DecodeString(string(aeskey))

	deckey, err := DecryptOTPWithAESKey(aeskeyData, otpkey)
	if err != nil {
		t.Fatal("Failed to decrypt key:", err)
	}
	fmt.Println("Decrypted key:", string(deckey))
}

//
//func TestEncryptAndDecrypt(t *testing.T) {
//	enckey, err := os.ReadFile("../val.otp")
//	if err != nil {
//		t.Fatal("Failed to read key file:", err)
//	}
//
//	deckey, err := DecryptPKWithTimeKey(enckey)
//	if err != nil {
//		t.Fatal("Failed to decrypt key:", err)
//	}
//	fmt.Println("Decrypted key:", string(deckey))
//}
