# How to run
1. make docker
2. modify config.yml for chain and mysql password.
3. modify docker-compose.yml for mysql password.
4. docker compose up -d 
5. docker compose down

# How to use
1. make docker
2. prepare a validator private key, write it to `secret/val.pk`
3. prepare a aes key.
```
docker run -it -v "${PWD}:/app" --rm token-bridge:latest validator genkey --output keys/aes.key 
```
4. crypt the private key with aes key, named it as val.fpk 
```
docker run -it -v "${PWD}:/app" --rm token-bridge:latest validator encrypt --in secret/val.pk --out secret/val.fpk --aes keys/aes.key
```

5. generate one-time-key for the validator.
```
docker run -it -v "${PWD}:/app" --rm token-bridge:latest validator onetime --in secret/val.fpk --out keys/val.otp
```

6. keep the `val.pk` safe and delete `val.pk`, `val.fpk` from the server. Must keep `aes.key` and `val.otp` exist.
7. start the validator service.
```
docker compose up -d
```

Tips: once you need restart the validator service, you need to generate a new one-time-key with the same command in step 5.
