package main

import (
	"code.wuban.net.cn/movabridge/token-bridge/chain"
	"code.wuban.net.cn/movabridge/token-bridge/config"
	"code.wuban.net.cn/movabridge/token-bridge/dao"
	"flag"
	"os"
	"os/signal"
	"syscall"

	log "github.com/sirupsen/logrus"
)

func init() {
	log.SetFormatter(&log.TextFormatter{
		FullTimestamp: true,
	})
}

func main() {
	flag.Parse()
	conf, err := config.New()
	if err != nil {
		panic(err)
	}

	d, err := dao.New(conf)
	if err != nil {
		panic(err)
	}

	if conf.Debug {
		log.SetLevel(log.DebugLevel)
	}
	syncers := make([]*chain.ChainSync, 0)

	for _, chainConfig := range conf.Chains {
		syncer := chain.NewChainSync(chainConfig, d)
		go syncer.Start()
		syncers = append(syncers, syncer)
	}

	// Set up signal handling
	sigCh := make(chan os.Signal, 1)
	signal.Notify(sigCh, syscall.SIGINT, syscall.SIGTERM)

	// Wait for termination signal
	sig := <-sigCh
	log.WithField("signal", sig.String()).Info("received termination signal, shutting down")

	// Stop all chain sync instances
	for _, syncer := range syncers {
		syncer.Stop()
	}

	log.Info("graceful shutdown completed")
	os.Exit(0)
}
