package util

import (
	"encoding/binary"
	"fmt"
	"strings"
	"testing"
	"time"

	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/crypto"
)

func TestGenHDKey(t *testing.T) {
	// xpub := "xpub69CSVbN4XnU6ituHBAnS4urNA2uiwcCciXWjJ7BKgsM5YAsQV1AfE1gEi7Aeip6dE6kFs3suNghVQukcmoGcdFYPohyAyX7KnxJNnqr2XSU"
	xpub := "xpub6C2ojpneBn4KHz1zaHpsyVHQMuJQbeDPbdkXywAUR43hXpjyQNcRv1ZQdvxnGmGKvXLoGPoN1G7cwfmW5CGZjPagpLnggXmqN52HhJk9F4B"

	// k, _ := GetPubKeyByPub(xpub, "0/1")
	// addr := crypto.PubkeyToAddress(*k)
	// t.Log(addr.String())

	userA := common.HexToAddress("0xAaf459E071637dE222D0a9e3b439704f478ed767")

	path := convertAddrToPath(userA.String())

	st := time.Now()
	k, _ := GetPubKeyByPub(xpub, path)
	addr2 := crypto.PubkeyToAddress(*k)
	t.Log(path, addr2.String())
	t.Log(time.Since(st))
	a, _ := GetDepositAddress(userA, xpub)
	t.Log(a.String())
	t.Log(addr2.String(), time.Since(st))

}

func convertAddrToPath(address string) string {
	addrBytes := common.HexToAddress(address).Bytes()
	// split to 8

	addrByteArray := make([]string, 7)
	for i := 0; i < 7; i++ {
		uint32Temp := uint32(0)
		if i == 6 {
			// fmt.Println("tt", tt)
			// binary.BigEndian.PutUint32(tt, addrByteArray[i])
			// fmt.Println("after tt", addrByteArray[i])
			uint32Temp = binary.BigEndian.Uint32(common.LeftPadBytes(addrBytes[i*3:i*3+2], 4))
		} else {
			// addrByteArray[i] = addrBytes[i*3 : i*3+3]
			// binary.BigEndian.PutUint32(temp4Byte(addrBytes[i*3:i*3+3]), addrByteArray[i])
			uint32Temp = binary.BigEndian.Uint32(common.LeftPadBytes(addrBytes[i*3:i*3+3], 4))
		}
		addrByteArray[i] = fmt.Sprintf("%d", uint32Temp)
	}

	fmt.Println(strings.Join(addrByteArray, "/"))
	return strings.Join(addrByteArray, "/")
}
