package dbModel

import (
	"gorm.io/gorm"
)

type Height struct {
	Key      string `gorm:"primaryKey"`
	IntValue int64  `gorm:"type:int;not null"` // 配置value
}

type BridgeEvent struct {
	FromChain       int64  `gorm:"type:int;comment:源链"`
	OutTimestamp    int64  `gorm:"type:int;comment:Out时间戳"`
	FromContract    string `gorm:"type:varchar(255);comment:源合约"`
	FromToken       string `gorm:"type:varchar(255);comment:源token"`
	FromAddress     string `gorm:"type:varchar(255);index;comment:源地址"`      // 用户地址
	FromChainTxHash string `gorm:"type:varchar(255);index;comment:源链交易hash"` // 源链交易hash
	SendAmount      string `gorm:"type:varchar(255);comment:发送金额"`           // 发送金额
	FeeAmount       string `gorm:"type:varchar(255);comment:手续费金额"`          // 手续费金额
	Receiver        string `gorm:"type:varchar(255);comment:接收者地址"`          // 目标链接收者地址
	ToChain         int64  `gorm:"type:int;comment:目标链"`
	ToToken         string `gorm:"type:varchar(255);comment:目标token"` // 目标链token
	ReceiveAmount   string `gorm:"type:varchar(255);comment:接收金额"`    // 接收金额 = 发送金额 - 手续费金额
	Hash            string `gorm:"type:varchar(255);uniqueIndex;comment:bridge hash"`
	OutId           int64  `gorm:"type:int;index;comment:源链转出ID"`
	InTimestamp     int64  `gorm:"type:int;comment:Out时间戳"`
	InId            int64  `gorm:"type:int;index;comment:源链转入ID"`
	ToContract      string `gorm:"type:varchar(255);comment:目标合约(toAddr)"`
	FinishTxHash    string `gorm:"type:varchar(255);comment:完成交易hash"` // 完成交易hash
	ToChainTxHash   string `gorm:"type:varchar(255);comment:目标链交易hash"`
	ToChainStatus   int    `gorm:"type:int;comment:目标链状态"` // 0未执行, 1等待确认, 2已执行, 3已拒绝
	ValidatorStatus int    `gorm:"type:int;comment:验证者状态"` // 0未验证, 1已确认, 2已拒绝, 3操作失败
	gorm.Model
}

type ValidatorEvent struct {
	ChainId      int64  `gorm:"type:int;comment:链ID"`
	Validator    string `gorm:"type:varchar(255);index;comment:验证者地址"`  // 验证者地址
	TxHash       string `gorm:"type:varchar(255);index;comment:交易hash"` // 交易hash
	Event        string `gorm:"type:varchar(255);index;comment:事件类型"`   // 事件类型
	TransferInId int64  `gorm:"type:int;index;comment:转入ID"`            // 转入ID
	Hash         string `gorm:"type:varchar(255);uniqueIndex;comment:event hash"`
	gorm.Model
}
