package util

import (
	"crypto/md5"
	"fmt"
	"math/big"
	"time"

	"golang.org/x/crypto/sha3"
)

func TextToHash(data []byte) []byte {
	msg := fmt.Sprintf("\x19Ethereum Signed Mesage:\n%d%s", len(data), string(data))
	hasher := sha3.NewLegacyKeccak256()
	hasher.Write([]byte(msg))
	return hasher.Sum(nil)
}

func GetUnixDay() *big.Int {
	return big.NewInt((time.Now().Unix() + 8*3600) / 86400)
}

func GetNonce(user string) (nonce *big.Int) {
	payload := append([]byte(user), GetUnixDay().Bytes()...)
	payload = append(payload, []byte{0x01}...)
	hash := md5.Sum(payload)
	return new(big.Int).SetBytes(hash[:6])
}
