package main

import (
	"code.wuban.net.cn/movabridge/token-bridge/encpk"
	"fmt"
	log "github.com/sirupsen/logrus"
	"github.com/spf13/cobra"
	"os"
)

var onetimeKeyCmd = &cobra.Command{
	Use:   "onetime",
	Short: "Generate a one-time-key from fpk",
	Long:  "Generate a one-time-key from fpk",
	Run: func(cmd *cobra.Command, args []string) {
		// Get flags
		inputFile, _ := cmd.Flags().GetString("in")
		outputFile, _ := cmd.Flags().GetString("out")

		// Read input text
		var plaintext string
		if inputFile != "" {
			data, err := os.ReadFile(inputFile)
			if err != nil {
				log.Fatal("Failed to read input file:", err)
			}
			plaintext = string(data)
		} else {
			log.Fatal("Input file is required")
		}

		encrypted, err := encpk.EncryptPKWithTimeKey([]byte(plaintext))
		if err != nil {
			log.Fatal("Failed to encrypt text:", err)
		}

		// Save to output file
		if outputFile != "" {
			err := os.WriteFile(outputFile, []byte(encrypted), 0644)
			if err != nil {
				log.Fatal("Failed to write output file:", err)
			}
			fmt.Printf("Text encrypted and saved to: %s\n", outputFile)
		} else {
			fmt.Printf("Encrypted text: %s\n", encrypted)
		}
	},
}

func init() {
	onetimeKeyCmd.Flags().StringP("in", "i", "", "Input file containing text to encrypt (required)")
	onetimeKeyCmd.Flags().StringP("out", "o", "validator.otk", "Output file for one-time-key")
	onetimeKeyCmd.MarkFlagRequired("in")
	rootCmd.AddCommand(onetimeKeyCmd)
}
