package dao

import (
	"bytes"
	"code.wuban.net.cn/movabridge/token-bridge/contract/bridge"
	"encoding/hex"
	"fmt"
	"github.com/ethereum/go-ethereum/accounts/abi"
	"github.com/ethereum/go-ethereum/common"
	"golang.org/x/crypto/sha3"
	"math/big"
	"testing"
)

func TestDao_AbiEncode(t *testing.T) {
	ether := new(big.Int).Exp(big.NewInt(10), big.NewInt(18), nil)
	param := bridge.BridgesubmitParams{
		ToChainID:   big.NewInt(2),
		Receiver:    common.HexToAddress("0x000000000000000000000000000000000000dead"),
		Token:       common.HexToAddress("0x000000000000000000000000000000000000beef"),
		Amount:      new(big.Int).Mul(big.NewInt(10), ether),
		OutId:       big.NewInt(1),
		FromChainID: big.NewInt(1),
		Sender:      common.HexToAddress("0x000000000000000000000000000000000000cafe"),
		SendToken:   common.HexToAddress("0x000000000000000000000000000000000000babe"),
		SendAmount:  new(big.Int).Mul(big.NewInt(10), ether),
	}
	expectHash := common.HexToHash("0x7be55178ff6b46f92c87979ffdffc36e242f0e559556c89f1f8403a71e72e09c")
	u256Type, _ := abi.NewType("uint256", "", nil)
	addrType, _ := abi.NewType("address", "", nil)
	arguments := abi.Arguments{
		{Type: u256Type},
		{Type: u256Type},
		{Type: addrType},
		{Type: addrType},
		{Type: u256Type},
		{Type: u256Type},
		{Type: addrType},
		{Type: addrType},
	}
	data, err := arguments.Pack(param.OutId, param.FromChainID, param.Sender, param.SendToken, param.SendAmount, param.ToChainID, param.Receiver, param.Token)
	if err != nil {
		t.Fatalf("failed to encode abi: %v", err)
	}
	fmt.Println("data=0x", hex.EncodeToString(data))
	sh := sha3.NewLegacyKeccak256()
	sh.Write(data)
	signature := sh.Sum(nil)
	if bytes.Compare(signature, expectHash[:]) != 0 {
		t.Errorf("expect hash: %x, got: %x", expectHash, signature)
	}
}
