package middleware

import (
	"math/rand"
	"strings"
	"time"

	"github.com/gin-gonic/gin"
	log "github.com/sirupsen/logrus"
)

func CheckHeaderMiddleware(invalidHeaders []string) gin.HandlerFunc {
	for _, invalidHeader := range invalidHeaders {
		log.WithField("invalid-header", invalidHeader).Debug("init invalid header")
	}

	return func(c *gin.Context) {
		// 获取user-agent
		userAgent := c.Request.Header.Get("User-Agent")
		for _, invalidHeader := range invalidHeaders {
			if strings.Contains(userAgent, invalidHeader) {
				time.Sleep(time.Millisecond * time.Duration(rand.Intn(100)+10))
				c.JSON(200, gin.H{
					"code": 0,
					"msg":  "ok",
					"data": "",
				})
				log.WithFields(log.Fields{"user-agent": userAgent}).Debug("invalid header, return fake data")
				c.Abort()
				return
			}
		}
		c.Next()
	}
}
