package dao

import (
	"code.wuban.net.cn/movabridge/token-bridge/contract/bridge"
	"context"
	"fmt"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/ethclient"
	"testing"
)

func TestParseTransferLog(t *testing.T) {
	url := "https://bsc-rpc.publicnode.com"
	txhash := "0x8765c23729f5e93ef6485d6589fb58f58c0fb50af7009cfcd646d98664cd61f9"
	contractAddr := "0x214C0b3d19ad265c258DeA678Cf1f5a63499c0d9"
	client, err := ethclient.Dial(url)
	if err != nil {
		t.Fatalf("failed to connect to the Ethereum client: %v", err)
	}
	contract, err := bridge.NewBridgeContract(common.HexToAddress(contractAddr), client)
	if err != nil {
		t.Fatalf("failed to instantiate a Bridge contract: %v", err)
	}
	receipt, err := client.TransactionReceipt(context.TODO(), common.HexToHash(txhash))
	if err != nil {
		t.Fatalf("failed to get transaction receipt: %v", err)
	}
	for _, vLog := range receipt.Logs {
		if vLog.Topics[0].Hex() == TransferOutEvent.ID.Hex() {
			event, err := contract.ParseTransferOut(*vLog)
			if err != nil {
				t.Fatalf("failed to parse TransferOut log: %v", err)
			}
			fmt.Printf("TransferOut event: %+v", event)
		}
	}
}
