const { ethers } = require("hardhat");

async function main() {
  console.log("开始部署测试合约以获取初始代码哈希...");
  
  // 部署测试合约
  const InitCodeHashTest = await ethers.getContractFactory("contracts/test/InitCodeHashTest.sol:InitCodeHashTest");
  const initCodeHashTest = await InitCodeHashTest.deploy();
  await initCodeHashTest.waitForDeployment();
  const initCodeHashTestAddress = await initCodeHashTest.getAddress();

    // 加载合约 0x72b0e88b8dd4c2765a0a76abcdff7a51783d15eb
    // const initCodeHashTest = await ethers.getContractAt("InitCodeHashTest", "0x554041535B01e019936D47153a75a18e8f0f64fc");
  
  console.log(`测试合约已部署到地址：${initCodeHashTestAddress}`);
  
  // 获取初始代码哈希
  const initCodeHash = await initCodeHashTest.getInitHash();
  console.log(`UniswapV2Pair 的初始代码哈希为：${initCodeHash}`);
  console.log(`以十六进制格式：0x${initCodeHash.slice(2)}`);
  
  console.log("\n您应该使用这个哈希值替换 UniswapV2Library.sol 中的硬编码值：");
  console.log(`hex'${initCodeHash.slice(2)}' // init code hash`);
}

main()
  .then(() => process.exit(0))
  .catch((error) => {
    console.error("执行过程中发生错误:", error);
    process.exit(1);
  });
