package controllers

import (
	"ai_developer_admin/libs/registry"
	"ai_developer_admin/models"
	"encoding/json"
	"github.com/beego/beego/v2/core/logs"
	"net/http"
)

type MonitorController struct {
	MainController
}

func (server *MonitorController) NodeManagers() {
	data, err := registry.NodeManagers()
	if err != nil {
		server.respond(models.BusinessFailed, err.Error())
		return
	}
	server.respond(http.StatusOK, "", data)
}

func (server *MonitorController) Gateways() {
	data, err := registry.Gateways()
	if err != nil {
		server.respond(models.BusinessFailed, err.Error())
		return
	}
	server.respond(http.StatusOK, "", data)
}

func (server *MonitorController) Workers() {
	data, err := registry.Workers()
	if err != nil {
		server.respond(models.BusinessFailed, err.Error())
		return
	}
	server.respond(http.StatusOK, "", data)
}

func (server *MonitorController) Schedules() {
	data, err := registry.Schedules()
	if err != nil {
		server.respond(models.BusinessFailed, err.Error())
		return
	}
	server.respond(http.StatusOK, "", data)
}

func (server *MonitorController) NodeManagersByPage() {
	body := server.Ctx.Input.RequestBody
	appRequest := models.AppRequest{}
	err := json.Unmarshal(body, &appRequest) //解析body中数据
	logs.Debug("appRequest", appRequest, string(body))

	if appRequest.Page > 0 {
		appRequest.Page = appRequest.Page - 1
	}

	if appRequest.Size == 0 {
		appRequest.Size = 10
	}
	data, total, err := registry.NodeManagersByPage(int(appRequest.Size), int(appRequest.Page))
	if err != nil {
		server.respond(models.BusinessFailed, err.Error())
		return
	}
	responseData := struct {
		Total int64       `json:"total"`
		Data  interface{} `json:"data,omitempty"`
	}{
		Total: int64(total),
		Data:  data,
	}
	server.respond(http.StatusOK, "", responseData)
}

func (server *MonitorController) GatewaysByPage() {
	body := server.Ctx.Input.RequestBody
	appRequest := models.AppRequest{}
	err := json.Unmarshal(body, &appRequest) //解析body中数据
	logs.Debug("appRequest", appRequest, string(body))

	if appRequest.Page > 0 {
		appRequest.Page = appRequest.Page - 1
	}

	if appRequest.Size == 0 {
		appRequest.Size = 10
	}
	data, total, err := registry.GatewaysByPage(int(appRequest.Size), int(appRequest.Page))
	if err != nil {
		server.respond(models.BusinessFailed, err.Error())
		return
	}
	responseData := struct {
		Total int64       `json:"total"`
		Data  interface{} `json:"data,omitempty"`
	}{
		Total: int64(total),
		Data:  data,
	}
	server.respond(http.StatusOK, "", responseData)
}

func (server *MonitorController) WorkersByPage() {
	body := server.Ctx.Input.RequestBody
	appRequest := models.AppRequest{}
	err := json.Unmarshal(body, &appRequest) //解析body中数据
	logs.Debug("appRequest", appRequest, string(body))

	if appRequest.Page > 0 {
		appRequest.Page = appRequest.Page - 1
	}

	if appRequest.Size == 0 {
		appRequest.Size = 10
	}
	data, total, err := registry.WorkersByPage(int(appRequest.Size), int(appRequest.Page))
	if err != nil {
		server.respond(models.BusinessFailed, err.Error())
		return
	}
	responseData := struct {
		Total int64       `json:"total"`
		Data  interface{} `json:"data,omitempty"`
	}{
		Total: int64(total),
		Data:  data,
	}
	server.respond(http.StatusOK, "", responseData)
}

func (server *MonitorController) SchedulesByPage() {
	body := server.Ctx.Input.RequestBody
	appRequest := models.AppRequest{}
	err := json.Unmarshal(body, &appRequest) //解析body中数据
	logs.Debug("appRequest", appRequest, string(body))

	if appRequest.Page > 0 {
		appRequest.Page = appRequest.Page - 1
	}
	if appRequest.Size == 0 {
		appRequest.Size = 10
	}
	data, total, err := registry.SchedulesByPage(int(appRequest.Size), int(appRequest.Page))
	if err != nil {
		server.respond(models.BusinessFailed, err.Error())
		return
	}
	responseData := struct {
		Total int64       `json:"total"`
		Data  interface{} `json:"data,omitempty"`
	}{
		Total: int64(total),
		Data:  data,
	}
	server.respond(http.StatusOK, "", responseData)
}
