package models

import "time"

type PayMethodType int

const (
	WeixinPay PayMethodType = iota + 1
	AliPay
	UnionPay
	PayPal
	ApplePay
	ManualPay
)

func (m PayMethodType) String() string {
	switch m {
	case WeixinPay:
		return "微信支付"
	case AliPay:
		return "支付宝"
	case UnionPay:
		return "银联支付"
	case PayPal:
		return "PayPal"
	case ApplePay:
		return "苹果支付"
	case ManualPay:
		return "手动充值"
	default:
		return "未知支付方式"
	}
}

type ChargeRequest struct {
	Amount        float64       `json:"amount"`
	PaymentMethod PayMethodType `json:"pay_method"`
}

type ChargeRecord struct {
	Id            int       `orm:"column(id);auto"`
	UserId        int       `json:"user_id";orm:"column(user_id)"`
	Amount        int64     `json:"amount";orm:"column(amount);size(7)"`
	PayMethod     int       `json:"pay_method";orm:"column(pay_method);size(1)"`
	PayMethodDesc string    `json:"pay_method_desc";orm:"column(pay_method_desc);size(20)"`
	Status        int       `json:"status";orm:"column(status);size(1)"`
	ChargeTime    time.Time `json:"charge_time";orm:"column(charge_time);type(datetime)"`
	CreatedTime   time.Time `json:"created_time";orm:"column(created_time);type(datetime)"`
	UpdatedTime   time.Time `json:"updated_time";orm:"column(updated_time);type(datetime)"`
	Deleted       int       `json:"deleted";orm:"column(deleted);size(1)"`
}
