package models

import (
	"time"
)

type Hardware struct {
	DiskSize   int64    `json:"disk_size,omitempty"`
	MemorySize int64    `json:"memory_size,omitempty"`
	Gpus       []string `json:"gpus,omitempty"`
}

type CMD struct {
	ImageName string `json:"image_name"`
	DockerCmd struct {
		ContainerPort string `json:"container_port"`
	} `json:"docker_cmd"`
	ApiUrl string `json:"api_url"`
}

type TaskType struct {
	Id              int       `orm:"column(id);auto"`
	Desc            string    `json:"desc";orm:"column(desc);size(20)"`
	Price           int64     `json:"price";orm:"column(price)"`
	PublicKey       string    `json:"public_key";orm:"column(public_key)"`
	Complexity      int       `json:"complexity";orm:"column(complexity)"`
	HardwareRequire string    `json:"hardware_require";orm:"column(hardware_require)"`
	ImageId         string    `json:"image_id";orm:"column(image_id)"`
	ImageUrl        string    `json:"image_url";orm:"column(image_url)"`
	Cmd             string    `json:"cmd";orm:"column(cmd)"`
	Workload        int       `json:"workload";orm:"column(workload)"`
	ApiPath         string    `json:"api_path";orm:"column(api_path)"`
	ImageName       string    `json:"image_name";orm:"column(image_name)"`
	SignUrl         string    `json:"sign_url";orm:"column(sign_url)"`
	Username        string    `json:"username";orm:"column(username)"`
	Password        string    `json:"password";orm:"column(password)"`
	CreatedTime     time.Time `json:"created_time";orm:"column(created_time);type(datetime)"`
	UpdatedTime     time.Time `json:"updated_time";orm:"column(updated_time);type(datetime)"`
	Deleted         int       `json:"deleted";orm:"column(deleted);size(1)"`
}

type NewTaskType struct {
	Id              int       `orm:"column(id);auto"`
	Desc            string    `json:"desc";orm:"column(desc);size(20)"`
	Price           int64     `json:"price";orm:"column(price)"`
	PublicKey       string    `json:"public_key";orm:"column(public_key)"`
	Complexity      int       `json:"complexity";orm:"column(complexity)"`
	HardwareRequire Hardware  `json:"hardware_require";orm:"column(hardware_require)"`
	ImageId         string    `json:"image_id";orm:"column(image_id)"`
	ImageUrl        string    `json:"image_url";orm:"column(image_url)"`
	Cmd             CMD       `json:"cmd";orm:"column(cmd)"`
	Workload        int       `json:"workload";orm:"column(workload)"`
	ApiPath         string    `json:"api_path";orm:"column(api_path)"`
	ImageName       string    `json:"image_name";orm:"column(image_name)"`
	SignUrl         string    `json:"sign_url";orm:"column(sign_url)"`
	Username        string    `json:"username";orm:"column(username)"`
	Password        string    `json:"password";orm:"column(password)"`
	CreatedTime     time.Time `json:"created_time";orm:"column(created_time);type(datetime)"`
	UpdatedTime     time.Time `json:"updated_time";orm:"column(updated_time);type(datetime)"`
	Deleted         int       `json:"deleted";orm:"column(deleted);size(1)"`
}

type Bills struct {
	//Key       int    `orm:"column(key);auto"`
	Id        string `json:"id";orm:"column(id)"`
	Type      string `json:"type";orm:"column(type)"`
	Uid       string `json:"uid";orm:"column(uid)"`
	ProfitAcc string `json:"profit_acc";orm:"column(profit_acc)"`
	Fee       string `json:"fee";orm:"column(fee)"`
	WorkerAcc string `json:"worker_acc";orm:"column(worker_acc)"`
	Result    string `json:"result";orm:"column(result)"`
	Workload  string `json:"workload";orm:"column(workload)"`
	//ApiPath   string    `json:"api_path";orm:"column(api_path)"`
	Time         time.Time `json:"time";orm:"column(time);type(datetime)"`
	TaskDuration string    `json:"task_duration";orm:"column(task_duration)"`
	OutLen       string    `json:"out_len";orm:"column(out_len)"`
	InLen        string    `json:"in_len";orm:"column(in_len)"`
	ApiPath      string    `json:"api_path,omitempty"`
	Desc         string    `json:"desc,omitempty"`
	TaskType     string    `json:"task_type,omitempty"`
	Balance      int64     `json:"balance,omitempty"`
}

type TaskCount struct {
	Time            time.Time `json:"time,omitempty"`
	Count           string    `json:"count,omitempty"`
	Fee             string    `json:"fee,omitempty"`
	Type            string    `json:"type,omitempty"`
	ApiPath         string    `json:"api_path,omitempty"`
	HardwareRequire string    `json:"hardware_require,omitempty"`
	ImageId         string    `json:"image_id,omitempty"`
	Repository      string    `json:"repository,omitempty"`
	ImageName       string    `json:"image_name,omitempty"`
	SignUrl         string    `json:"sign_url,omitempty"`
	User            string    `json:"user,omitempty"`
	Pwd             string    `json:"pwd,omitempty"`
	TaskId          int       `json:"task_id,omitempty"`
}

type TaskHeat struct {
	Time            time.Time `json:"time,omitempty"`
	Count           int64     `json:"count,omitempty"`
	ApiPath         string    `json:"api_path,omitempty"`
	HardwareRequire Hardware  `json:"hardware_require,omitempty"`
	ImageId         string    `json:"image_id,omitempty"`
	Repository      string    `json:"repository,omitempty"`
	ImageName       string    `json:"image_name,omitempty"`
	SignUrl         string    `json:"sign_url,omitempty"`
	User            string    `json:"user,omitempty"`
	Pwd             string    `json:"pwd,omitempty"`
	TaskId          int       `json:"task_id,omitempty"`
}

//type Tasks struct {
//	//Key  int    `orm:"column(key);auto"`
//	Id   string `json:"id";orm:"column(id)"`
//	Type string `json:"type";orm:"column(type)"`
//	Uid  string `json:"uid";orm:"column(uid)"`
//	Fee  int    `json:"fee";orm:"column(fee)"`
//	//ApiPath string    `json:"api_path";orm:"column(api_path)"`
//	Time  time.Time `json:"time";orm:"column(time);type(datetime)"`
//	InLen int       `json:"in_len";orm:"column(in_len)"`
//}

type AddTaskType struct {
	Type   NewTaskType         `json:"type"`
	Levels []UserLevelTaskType `json:"levels"`
}
