package models

import "time"

//type User struct {
//	Id       int    `json:"id" orm:"column(id);auto"`
//	Username string `json:"username" orm:"column(username);size(128)"`
//	Password string `json:"password" orm:"column(password);size(128)"`
//	Phone    string `json:"phone" orm:"column(phone);size(128)"`
//	CustomId string `json:"custom_id" orm:"column(custom_id);size(128)"`
//}

type User struct {
	Id                int       `orm:"column(id);auto"`
	Name              string    `json:"name";orm:"column(name);size(20)"`
	Username          string    `json:"user_name";orm:"column(user_name);size(20)"`
	Mail              string    `json:"mail";orm:"column(mail);size(120)"`
	Phone             string    `json:"phone";orm:"column(phone);size(15)"`
	CustomId          string    `json:"custom_id";orm:"column(custom_id);size(120)"`
	ChainAccount      string    `json:"chain_account";orm:"column(chain_account);size(42)"`
	Type              int       `json:"type";orm:"column(type);size(1)"`
	IsAuthed          int       `json:"is_authed";orm:"column(is_authed);size(1)"`
	RegisterFrom      int       `json:"register_from";orm:"column(register_from);size(1)"`
	RegisterFromDesc  string    `json:"register_from_desc";orm:"column(register_from_desc);size(16)"`
	Balance           int64     `json:"balance";orm:"column(balance)"`
	Level             int       `json:"level";orm:"column(level);size(1)"`
	VerifierId        string    `json:"verifier_id";orm:"column(verifier_id);size(255)"`
	RateLimitPluginId string    `json:"rate_limit_plugin_id";orm:"column(rate_limit_plugin_id);size(255)"`
	ProfileImage      string    `json:"profile_image";orm:"column(profile_image);size(255)"`
	Role              int       `json:"role";orm:"column(role);size(1)"`
	CreatedTime       time.Time `json:"created_time";orm:"column(created_time);type(datetime)"`
	UpdatedTime       time.Time `json:"updated_time";orm:"column(updated_time);type(datetime)"`
	Deleted           int       `json:"deleted";orm:"column(deleted);size(1)"`
}

type LoginRequest struct {
	RequstUser        User   `json:"user"`
	IdToken           string `json:"id_token"`
	Web3AuthPublicKey string `json:"web3auth_public_key"`
}

type UserLevel struct {
	Id                 int       `orm:"column(id);auto"`
	Desc               string    `json:"desc";orm:"column(desc);size(20)"`
	CreditQuota        int64     `json:"credit_quota";orm:"column(credit_quota)"`
	FreeCallCountDay   int       `json:"free_call_count_day";orm:"column(free_call_count_day)"`
	FreeCallCountMonth int       `json:"free_call_count_month";orm:"column(free_call_count_month)"`
	FreeCallCountYear  int       `json:"free_call_count_year";orm:"column(free_call_count_year)"`
	FreeCallCountTotal int       `json:"free_call_count_total";orm:"column(free_call_count_total)"`
	RateLimitSecond    int       `json:"rate_limit_second";orm:"column(rate_limit_second)"`
	RateLimitMinute    int       `json:"rate_limit_minute";orm:"column(rate_limit_minute)"`
	RateLimitHour      int       `json:"rate_limit_hour";orm:"column(rate_limit_hour)"`
	RateLimitDay       int       `json:"rate_limit_day";orm:"column(rate_limit_day)"`
	RateLimitMonth     int       `json:"rate_limit_month";orm:"column(rate_limit_month)"`
	RateLimitYear      int64     `json:"rate_limit_year";orm:"column(rate_limit_year)"`
	Level              int       `json:"level";orm:"column(level);size(1)"`
	CreatedTime        time.Time `json:"created_time";orm:"column(created_time);type(datetime)"`
	UpdatedTime        time.Time `json:"updated_time";orm:"column(updated_time);type(datetime)"`
	Deleted            int       `json:"deleted";orm:"column(deleted);size(1)"`
}

type UserLevelTaskType struct {
	ID                 int       `orm:"column(id);auto"`
	FreeCallCountDay   int       `json:"free_call_count_day"orm:"column(free_call_count_day)"`
	FreeCallCountMonth int       `json:"free_call_count_month"orm:"column(free_call_count_month)"`
	FreeCallCountYear  int       `json:"free_call_count_year"orm:"column(free_call_count_year)"`
	FreeCallCountTotal int       `json:"free_call_count_total"orm:"column(free_call_count_total)"`
	UserLevel          int       `json:"user_level"orm:"column(user_level)"`
	TaskTypeId         int       `json:"task_type_id"orm:"column(task_type_id)"`
	CreatedTime        time.Time `json:"created_time";orm:"column(created_time);type(datetime)"`
	UpdatedTime        time.Time `json:"updated_time";orm:"column(updated_time);type(datetime)"`
	Deleted            int       `json:"deleted";orm:"column(deleted);size(1)"`
}
