package odysseus

import (
	"ai_developer_admin/models"
	"context"
	"github.com/beego/beego/v2/core/logs"
	"github.com/odysseus/cache/cachedata"
	"github.com/odysseus/cache/model"
)

import (
	beego "github.com/beego/beego/v2/server/web"
)

var syncinfo *cachedata.CacheData

func init() {
	//return
	host, _ := beego.AppConfig.String("balancehost")
	db, _ := beego.AppConfig.Int("balancedb")
	pass, _ := beego.AppConfig.String("balancepass")
	//syncinfo = payment.NewPayment(payment.RedisConnParam{
	//	Addr:     host,
	//	Password: pass,
	//	DbIndex:  db,
	//})
	dbuser, _ := beego.AppConfig.String("mysqluser")
	dbpass, _ := beego.AppConfig.String("mysqlpass")
	dbhost, _ := beego.AppConfig.String("mysqlhost")
	dbport, _ := beego.AppConfig.Int("mysqlport")
	dbname, _ := beego.AppConfig.String("mysqldb")
	syncinfo = cachedata.NewCacheData(context.Background(), cachedata.RedisConnParam{
		Addr:     host,
		Password: pass,
		DbIndex:  db,
	}, model.DbConfig{
		User:   dbuser,
		Host:   dbhost,
		Port:   dbport,
		DbName: dbname,
		Passwd: dbpass,
	})
}

func SetUserInfo(user *models.User) error {
	data := &model.User{
		ID:      int64(user.Id),
		Level:   int64(user.Level),
		Balance: user.Balance,
		Deleted: int64(user.Deleted),
	}
	return syncinfo.SetUserInfo(data)
}

func GetUserBalance(id int64) (int64, error) {
	user, err := syncinfo.GetUserInfo(id)
	logs.Debug("GetUserInfo = ", user, err)
	return user.Balance, err
}

//func GetUserBalance(id int64) (int64, error) {
//	user, err := syncinfo.GetUserInfo(id)
//	logs.Debug("GetUserInfo = ", user, err)
//	return user.Balance, err
//}

func SetTaskDataToRedis(task *model.TaskType) error {
	return syncinfo.SetTaskDataToRedis(task)
}

func GetTaskType(id int64) (*model.TaskType, error) {
	return syncinfo.GetTaskWithId(id)
}

func PublichTaskUpdate(path string) error {
	return syncinfo.PublichTaskUpdate(path)
}

func SetWhiteListToRedis(wh *model.Whitelist) error {
	return syncinfo.SetWhiteListToRedis(wh)
}

func DeleteWhiteList(wh *model.Whitelist) error {
	return syncinfo.DeleteWhiteList(wh)
}
