package main

import (
	"ai_developer_admin/libs/cronjob"
	"ai_developer_admin/libs/mysql"
	"ai_developer_admin/libs/registry"
	_ "ai_developer_admin/routers"
	"fmt"
	beego "github.com/beego/beego/v2/server/web"
	"github.com/beego/beego/v2/server/web/filter/cors"
	_ "github.com/beego/beego/v2/server/web/session/redis"
	"time"
)

func init() {
	runmode, _ := beego.AppConfig.String("runmode")
	if runmode != "prod" {
		beego.InsertFilter("*", beego.BeforeRouter, cors.Allow(&cors.Options{
			AllowAllOrigins:  true,
			AllowMethods:     []string{"GET", "POST", "PUT", "DELETE", "OPTIONS"},
			AllowHeaders:     []string{"Origin", "Authorization", "Access-Control-Allow-Origin", "Access-Control-Allow-Headers", "Content-Type", "X-Xsrf-Token"},
			ExposeHeaders:    []string{"Content-Length", "Access-Control-Allow-Origin", "Access-Control-Allow-Headers", "Content-Type", "X-Xsrf-Token", "Authorization"},
			AllowCredentials: true,
		}))
	}

	beego.SetStaticPath("/uploads", "uploads")
}

func main() {
	//t := time.Now()
	//temp := fmt.Sprintf(t.Format("2006-01-02T15:04:05.000000Z"))
	//logs.Debug("temp = ", temp)

	//log.InitLog(log.LogConfig{Path: "logs", Level: "debug", Save: 3})

	//level, _ := beego.AppConfig.Int("logLevel")
	//logs.SetLevel(level)
	//fileName, _ := beego.AppConfig.String("logfile")
	//if fileName != "" {
	//	config := fmt.Sprintf("{\"filename\":\"%s\"}", fileName)
	//	logs.SetLogger(logs.AdapterFile, config)
	//}

	str := "2024-02-01T18:41:30"
	layout := "2006-01-02T15:04:05"
	t, _ := time.Parse(layout, str)
	fmt.Print("t = %s", t)
	//currentTime := time.Now()
	////if appRequest.EndTime == nil {
	//tempendTime := time.Date(currentTime.Year(), currentTime.Month(), currentTime.Day(), 23, 59, 59, 0, currentTime.Location())
	//endTime := &tempendTime
	////}
	////if appRequest.StartTime == nil {
	//temp := fmt.Sprintf("-%dh", 24*7)
	//m, _ := time.ParseDuration(temp)
	//tempTime := currentTime.Add(m)
	//tempTime = time.Date(tempTime.Year(), tempTime.Month(), tempTime.Day(), 0, 0, 0, 0, tempTime.Location())
	//startTime := &tempTime
	////}
	//startTimeStr := fmt.Sprintf(startTime.Format("2006-01-02T15:04:05.000000Z"))
	//endTimeStr := fmt.Sprintf(endTime.Format("2006-01-02T15:04:05.000000Z"))
	//
	//dates := utils.SplitDate(startTimeStr, endTimeStr, "2006-01-02T15:04:05.000000Z")
	//logs.Debug("dates = ", dates)

	//currentTime := time.Now()
	////start := time.Date(2023, 4, 1, 0, 0, 0, 0, currentTime.Location())
	//end := time.Date(2024, 4, 1, 0, 0, 0, 0, currentTime.Location())
	//
	////currentTime := time.Now()
	////end := time.Date(currentTime.Year(), currentTime.Month(), currentTime.Day(), 23, 59, 59, 0, time.UTC)
	//temp := fmt.Sprintf("-%dh", 24*365)
	//m, _ := time.ParseDuration(temp)
	//tempTime := end.Add(m)
	//if tempTime.Day() != 1 {
	//	tempTime = tempTime.AddDate(0, 1, 0)
	//}
	//tempTime = time.Date(tempTime.Year(), tempTime.Month(), tempTime.Day(), 0, 0, 0, 0, time.UTC)
	////endDateIn := time.Date(end.Year(), end.Month(), end.Day(), 0, 0, 0, 0, time.UTC)
	////endDate := fmt.Sprintf(endDateIn.Format("2006-01-02T15:04:05.000000Z"))
	//
	//months := yearMonthRange(tempTime, end)
	//for _, month := range months {
	//	fmt.Println(month)
	//}

	cronjob.Start()
	mysql.GetMysqlInstace()
	//postgres.Query("")
	registry.RegistryBackend()
	beego.Run()

	//id, err := snowflake.NextId()
	//if err != nil {
	//	logs.Debug("dates = ", err.Error())
	//}
	//logs.Debug("id = ", id)
	//id, err = snowflake.NextId()
	//if err != nil {
	//	logs.Debug("dates = ", err.Error())
	//}
	//logs.Debug("id = ", id)
}

func yearMonthRange(start, end time.Time) []string {
	// 创建年月数组
	start = time.Date(start.Year(), start.Month(), 1, 0, 0, 0, 0, start.Location())
	//end = time.Date(end.Year(), end.Month(), 1, 0, 0, 0, 0, end.Location())
	yms := make([]string, 0)

	// 遍历每个月
	temp := end.AddDate(0, 1, 0)
	for t := start; t.Compare(end) <= 0; t = t.AddDate(0, 1, 0) {
		temp = end.AddDate(0, 1, 0)
		yms = append(yms, t.Format("2006-01-02T15:04:05.000000Z"))
	}
	fmt.Println(temp)

	return yms
}

func dayRange(start, end time.Time) []time.Time {
	// 创建天数组
	days := make([]time.Time, 0)

	// 遍历每一天
	for t := start; t.Before(end.AddDate(0, 0, 1)); t = t.AddDate(0, 0, 1) {
		days = append(days, t)
	}

	return days
}

func monthRange(start, end time.Time) []time.Month {
	// 创建月份数组
	months := make([]time.Month, 0)

	// 遍历每个月
	for t := start; t.Before(end.AddDate(0, 1, 0)); t = t.AddDate(0, 1, 0) {
		months = append(months, t.Month())
	}

	return months
}
