package models

import (
	"time"
)

//type Hardware struct {
//	DiskSize   int64    `json:"disk_size,omitempty"`
//	MemorySize int64    `json:"memory_size,omitempty"`
//	Gpus       []string `json:"gpus,omitempty"`
//}
//
//type CMD struct {
//	ImageName string `json:"image_name"`
//	DockerCmd struct {
//		ContainerPort string `json:"container_port"`
//	} `json:"docker_cmd"`
//	ApiUrl string `json:"api_url"`
//}

type ExampleType struct {
	Title string `json:"title"`
	Input struct {
		Prompt string `json:"prompt,omitempty"`
		Url    string `json:"url,omitempty"`
		//Mask   string `json:"mask,omitempty"`
	} `json:"input"`
	Output struct {
		Text string `json:"text,omitempty"`
		Url  string `json:"url,omitempty"`
	} `json:"output"`
}

type Category struct {
	Id          int       `json:"id";orm:"column(id);auto"`
	Desc        string    `json:"desc";orm:"column(desc);size(20)"`
	EnDesc      string    `json:"en_desc";orm:"column(en_desc);size(20)"`
	Sort        int       `json:"sort";orm:"column(sort)"`
	CreatedTime time.Time `json:"created_time";orm:"column(created_time);type(datetime)"`
	UpdatedTime time.Time `json:"updated_time";orm:"column(updated_time);type(datetime)"`
	Deleted     int       `json:"deleted";orm:"column(deleted);size(1)"`
}

type Computility struct {
	Id          int    `json:"id";orm:"column(id);auto"`
	Model       string `json:"model";orm:"column(model)"`
	Series      string `json:"series";orm:"column(series)"`
	Cuda        string `json:"cuda";orm:"column(cuda)"`
	VideoMemory int    `json:"video_memory";orm:"column(video_memory)"`
	Factor      int    `json:"factor";orm:"column(factor)"`
	Computility int    `json:"computility";orm:"column(computility)"`
	Type        int    `json:"type";orm:"column(type)"`
	Brand       string `json:"brand";orm:"column(brand);"`
	CreatedTime string `json:"created_time";orm:"column(created_time)"`
	UpdatedTime string `json:"updated_time";orm:"column(updated_time)"`
	Deleted     int    `json:"deleted";orm:"column(deleted)"`
}

type TaskType struct {
	Id                int       `json:"id";orm:"column(id);auto"`
	Name              string    `json:"name";orm:"column(name);size(20)"`
	Version           string    `json:"version,omitempty";orm:"column(version)"`
	Desc              string    `json:"desc";orm:"column(desc);size(20)"`
	Price             int64     `json:"price";orm:"column(price)"`
	PublicKey         string    `json:"public_key";orm:"column(public_key)"`
	Complexity        int       `json:"complexity";orm:"column(complexity)"`
	Type              int       `json:"type";orm:"column(type)"`
	Kind              int       `json:"kind";orm:"column(kind)"`
	HardwareRequire   string    `json:"hardware_require";orm:"column(hardware_require)"`
	ImageId           string    `json:"image_id";orm:"column(image_id)"`
	ImageUrl          string    `json:"image_url";orm:"column(image_url)"`
	Cmd               string    `json:"cmd";orm:"column(cmd)"`
	Workload          int       `json:"workload";orm:"column(workload)"`
	ApiPath           string    `json:"api_path";orm:"column(api_path)"`
	ImageName         string    `json:"image_name";orm:"column(image_name)"`
	SignUrl           string    `json:"sign_url";orm:"column(sign_url)"`
	Username          string    `json:"username";orm:"column(username)"`
	Password          string    `json:"password";orm:"column(password)"`
	Model             string    `json:"model";orm:"column(model)"`
	BaseModel         string    `json:"base_model";orm:"column(base_model)"`
	Examples          string    `json:"examples";orm:"column(examples)"`
	ApiDocUrl         string    `json:"api_doc_url";orm:"column(api_doc_url)"`
	ApiDocContent     string    `json:"api_doc_content";orm:"column(api_doc_content)"`
	Codes             string    `json:"codes";orm:"column(codes)"`
	Tags              string    `json:"tags";orm:"column(tags)"`
	Category          int       `json:"category";orm:"column(category)"`
	Form              string    `json:"form";orm:"column(form)"`
	ResultFileExpires int       `json:"result_file_expires";orm:"column(result_file_expires)"`
	AccessStatus      int       `json:"access_status,omitempty"`
	PublishStatus     int       `json:"publish_status,omitempty"`
	Unit              string    `json:"unit";orm:"column(unit)"`
	CreatedTime       time.Time `json:"created_time";orm:"column(created_time);type(datetime)"`
	UpdatedTime       time.Time `json:"updated_time";orm:"column(updated_time);type(datetime)"`
	Deleted           int       `json:"deleted";orm:"column(deleted);size(1)"`
}

type NewTaskType struct {
	Id                int         `json:"id";orm:"column(id);auto"`
	Name              string      `json:"name";orm:"column(desc)"`
	BaseModel         string      `json:"base_model";orm:"column(desc)"`
	Model             string      `json:"model";orm:"column(model)"`
	Version           string      `json:"version";orm:"column(desc)"`
	Desc              string      `json:"desc";orm:"column(desc);size(20)"`
	Price             float64     `json:"price";orm:"column(price)"`
	PublicKey         string      `json:"public_key";orm:"column(public_key)"`
	Complexity        int         `json:"complexity";orm:"column(complexity)"`
	Type              ModelType   `json:"type,omitempty";orm:"column(type)"`
	Kind              int         `json:"kind";orm:"column(kind)"`
	TypeDesc          string      `json:"type_desc"`
	KindDesc          string      `json:"kind_desc"`
	KindDescEn        string      `json:"kind_desc_en"`
	HardwareRequire   interface{} `json:"hardware_require";orm:"column(hardware_require)"`
	ImageId           string      `json:"image_id";orm:"column(image_id)"`
	ImageUrl          string      `json:"image_url";orm:"column(image_url)"`
	Cmd               interface{} `json:"cmd";orm:"column(cmd)"`
	Workload          int         `json:"workload";orm:"column(workload)"`
	ApiPath           string      `json:"api_path";orm:"column(api_path)"`
	ImageName         string      `json:"image_name";orm:"column(image_name)"`
	SignUrl           string      `json:"sign_url";orm:"column(sign_url)"`
	Username          string      `json:"username";orm:"column(username)"`
	Password          string      `json:"password";orm:"column(password)"`
	Examples          interface{} `json:"examples,omitempty";orm:"column(examples)"`
	ApiDocUrl         string      `json:"api_doc_url,omitempty";orm:"column(api_doc_url)"`
	ApiDocContent     string      `json:"api_doc_content,omitempty";orm:"column(api_doc_content)"`
	Codes             interface{} `json:"codes,omitempty";orm:"column(codes)"`
	Tags              []string    `json:"tags,omitempty";orm:"column(tags)"`
	Category          int         `json:"category";orm:"column(category)"`
	Form              string      `json:"form";orm:"column(form)"`
	ResultFileExpires int         `json:"result_file_expires";orm:"column(result_file_expires)"`
	AccessStatus      int         `json:"access_status,omitempty"`
	PublishStatus     int         `json:"publish_status,omitempty"`
	Unit              string      `json:"unit";orm:"column(unit)"`
	CreatedTime       time.Time   `json:"created_time";orm:"column(created_time);type(datetime)"`
	UpdatedTime       time.Time   `json:"updated_time";orm:"column(updated_time);type(datetime)"`
	Deleted           int         `json:"deleted";orm:"column(deleted);size(1)"`
}

type Model struct {
	Id                int    `json:"id";orm:"column(id);auto"`
	Tit               string `json:"tit";orm:"column(tit);size(20)"`
	Version           string `json:"version,omitempty";orm:"column(version)"`
	Content           string `json:"content";orm:"column(content);size(20)"`
	Type              int    `json:"type";orm:"column(type)"`
	ApiPath           string `json:"api_path";orm:"column(api_path)"`
	BaseModel         string `json:"base_model";orm:"column(base_model)"`
	Model             string `json:"model";orm:"column(model)"`
	Examples          string `json:"examples";orm:"column(examples)"`
	ApiDocUrl         string `json:"api_doc_url";orm:"column(api_doc_url)"`
	ApiDocContent     string `json:"api_doc_content";orm:"column(api_doc_content)"`
	Codes             string `json:"codes";orm:"column(codes)"`
	Tags              string `json:"tags";orm:"column(tags)"`
	Form              string `json:"form";orm:"column(form)"`
	Category          int    `json:"category";orm:"column(category)"`
	ResultFileExpires int    `json:"result_file_expires";orm:"column(result_file_expires)"`
	AccessStatus      int    `json:"access_status,omitempty"`
	PublishStatus     int    `json:"publish_status,omitempty"`
	Price             int64  `json:"price";orm:"column(price)"`
	Unit              string `json:"unit";orm:"column(unit)"`
}

type ResonseModel struct {
	Id                int         `json:"id";orm:"column(id)"`
	Tit               string      `json:"tit";orm:"column(tit);size(20)"`
	Version           string      `json:"version,omitempty";orm:"column(version)"`
	Content           string      `json:"content";orm:"column(content);size(20)"`
	Type              int         `json:"type";orm:"column(type)"`
	ApiPath           string      `json:"api_path";orm:"column(api_path)"`
	BaseModel         string      `json:"base_model";orm:"column(base_model)"`
	Model             string      `json:"model";orm:"column(model)"`
	Examples          interface{} `json:"examples";orm:"column(examples)"`
	ApiDocUrl         string      `json:"api_doc_url,omitempty";orm:"column(api_doc_url)"`
	ApiDocContent     string      `json:"api_doc_content,omitempty";orm:"column(api_doc_content)"`
	Codes             interface{} `json:"codes";orm:"column(codes)"`
	Tags              interface{} `json:"tags";orm:"column(tags)"`
	Category          int         `json:"category";orm:"column(category)"`
	Form              interface{} `json:"form";orm:"column(form)"`
	ResultFileExpires int         `json:"result_file_expires";orm:"column(result_file_expires)"`
	AccessStatus      int         `json:"access_status,omitempty"`
	PublishStatus     int         `json:"publish_status,omitempty"`
	Price             float64     `json:"price";orm:"column(price)"`
	Unit              string      `json:"unit";orm:"column(unit)"`
}

type Bills struct {
	//Key       int    `orm:"column(key);auto"`
	Id        string `json:"id";orm:"column(id)"`
	Type      string `json:"type";orm:"column(type)"`
	Kind      string `json:"kind,omitempty"`
	Uid       string `json:"uid";orm:"column(uid)"`
	ProfitAcc string `json:"profit_acc";orm:"column(profit_acc)"`
	Fee       string `json:"fee";orm:"column(fee)"`
	WorkerAcc string `json:"worker_acc";orm:"column(worker_acc)"`
	Result    string `json:"result";orm:"column(result)"`
	Workload  string `json:"workload";orm:"column(workload)"`
	//ApiPath   string    `json:"api_path";orm:"column(api_path)"`
	Time         time.Time `json:"time";orm:"column(time);type(datetime)"`
	TaskDuration string    `json:"task_duration";orm:"column(task_duration)"`
	OutLen       string    `json:"out_len";orm:"column(out_len)"`
	InLen        string    `json:"in_len";orm:"column(in_len)"`
	ApiPath      string    `json:"api_path,omitempty"`
	Desc         string    `json:"desc,omitempty"`
	TaskType     string    `json:"task_type,omitempty"`
	Balance      int64     `json:"balance,omitempty"`
	BaseModel    string    `json:"base_model,omitempty"`
	Model        string    `json:"model,omitempty"`
}

type TotalType struct {
	Count string `json:"count,omitempty"`
}

type TaskCount struct {
	Time            time.Time `json:"time,omitempty"`
	Count           string    `json:"count,omitempty"`
	Fee             string    `json:"fee,omitempty"`
	Type            string    `json:"type,omitempty"`
	ApiPath         string    `json:"api_path,omitempty"`
	HardwareRequire string    `json:"hardware_require,omitempty"`
	ImageId         string    `json:"image_id,omitempty"`
	Repository      string    `json:"repository,omitempty"`
	ImageName       string    `json:"image_name,omitempty"`
	SignUrl         string    `json:"sign_url,omitempty"`
	User            string    `json:"user,omitempty"`
	Pwd             string    `json:"pwd,omitempty"`
	TaskId          int       `json:"task_id,omitempty"`
}

type TaskHeat struct {
	Time            time.Time   `json:"time,omitempty"`
	Count           int64       `json:"count,omitempty"`
	ApiPath         string      `json:"api_path,omitempty"`
	HardwareRequire interface{} `json:"hardware_require,omitempty"`
	ImageId         string      `json:"image_id,omitempty"`
	Repository      string      `json:"repository,omitempty"`
	ImageName       string      `json:"image_name,omitempty"`
	SignUrl         string      `json:"sign_url,omitempty"`
	User            string      `json:"user,omitempty"`
	Pwd             string      `json:"pwd,omitempty"`
	TaskId          int         `json:"task_id,omitempty"`
	Kind            int         `json:"kind";orm:"column(kind)"`
	FileExpiresTime string      `json:"file_expires_time";orm:"column(file_expires_time)"`
	OutPutJson      interface{} `json:"out_put_json";orm:"column(out_put_json)"`
	AccessStatus    int         `json:"access_status,omitempty"`
	PublishStatus   int         `json:"publish_status,omitempty"`
}

type AddTaskType struct {
	TaskTypeIn NewTaskType         `json:"task_type"`
	Levels     []UserLevelTaskType `json:"levels"`
}

type ModelType int

const (
	TXTTOIMG ModelType = iota + 1
	TXTTOTXT
	TXTTOVIDEO
	IMGTOTXT
	IMGTOVIDEO
	IMGTOIMG
	IMGTXTTOTXT
	IMGTXTTOIMG
	IMGTXTTOVIDEO
	TXTTOSPEECH
	SPEECHTOTXT
)

func (m ModelType) String() string {
	switch m {
	case TXTTOIMG:
		return "txt2img"
	case TXTTOTXT:
		return "txt2txt"
	case TXTTOVIDEO:
		return "txt2video"
	case IMGTOTXT:
		return "img2txt"
	case IMGTOVIDEO:
		return "img2video"
	case IMGTOIMG:
		return "img2img"
	case IMGTXTTOTXT:
		return "imgtxt2txt"
	case IMGTXTTOIMG:
		return "imgtxt2img"
	case IMGTXTTOVIDEO:
		return "imgtxt2video"
	case TXTTOSPEECH:
		return "txt2speech"
	case SPEECHTOTXT:
		return "speech2txt"
	default:
		return "未知类型"
	}
}

type TaskKind int

const (
	SystemTask   TaskKind = iota
	ComputeTask           = 1
	CustomTask            = 2
	StandardTask          = 3
)

func (m TaskKind) String() string {
	switch m {
	case SystemTask:
		return "系统任务"
	case ComputeTask:
		return "计算任务"
	case CustomTask:
		return "自定义任务"
	case StandardTask:
		return "标准任务"
	default:
		return "未知类型"
	}
}

func (m TaskKind) EnString() string {
	switch m {
	case SystemTask:
		return "System Task"
	case ComputeTask:
		return "Compute Task"
	case CustomTask:
		return "Custom Task"
	case StandardTask:
		return "Standard Task"
	default:
		return "unknown Task Type"
	}
}

type FeeConditionEnum int

const (
	FeeAll FeeConditionEnum = iota + 1
	FeeFree
	FeeBased
)

func (m FeeConditionEnum) String() string {
	switch m {
	case FeeAll:
		return "全部"
	case FeeFree:
		return "免费"
	case FeeBased:
		return "收费"
	default:
		return "未知类型"
	}
}

func (m FeeConditionEnum) EnString() string {
	switch m {
	case FeeAll:
		return "All"
	case FeeFree:
		return "Free"
	case FeeBased:
		return "Fee Based"
	default:
		return "unknown"
	}
}

type PublishStatusEnum int

const (
	Publish PublishStatusEnum = iota + 1
	UnPublish
)

func (m PublishStatusEnum) String() string {
	switch m {
	case Publish:
		return "发布"
	case UnPublish:
		return "取消发布"
	default:
		return "未知类型"
	}
}

func (m PublishStatusEnum) EnString() string {
	switch m {
	case Publish:
		return "UnPublish"
	case UnPublish:
		return "UnPublish"
	default:
		return "unknown"
	}
}

type AccessStatusEnum int

const (
	Public AccessStatusEnum = iota + 1
	Private
)

func (m AccessStatusEnum) String() string {
	switch m {
	case Public:
		return "公开"
	case Private:
		return "私有"
	default:
		return "未知"
	}
}

func (m AccessStatusEnum) EnString() string {
	switch m {
	case Public:
		return "Public"
	case Private:
		return "Private"
	default:
		return "unknown"
	}
}
