package models

import (
	"math/big"
	"time"
)

type Revenues struct {
	Id        string     `json:"id,omitempty";orm:"column(id)"`
	Time      time.Time  `json:"time,omitempty";orm:"column(time);type(datetime)"`
	Type      string     `json:"type,omitempty";orm:"column(type)"`
	BaseModel string     `json:"base_model,omitempty";orm:"column(base_model)"`
	ProfitAcc string     `json:"profit_acc,omitempty";orm:"column(profit_acc)"`
	WorkerAcc string     `json:"worker_acc,omitempty";orm:"column(worker_acc)"`
	Workload  int64      `json:"workload,omitempty";orm:"column(workload)"`
	Income    *big.Float `json:"income,omitempty";orm:"column(income)"`
	TaskId    int        `json:"task_type_id,omitempty"`
}

type WeiStruct struct {
	Id   string    `json:"id,omitempty";orm:"column(id)"`
	Time time.Time `json:"time,omitempty";orm:"column(time);type(datetime)"`
	Wei  string    `json:"wei,omitempty";orm:"column(wei)"`
}

type WeiPerWorkloadStruct struct {
	Date           string `json:"date,omitempty"`
	WeiPerWorkload string `json:"weiPerWorkload,omitempty"`
	Workload       string `json:"workload,omitempty"`
	Reward         string `json:"reward,omitempty"`
}

type WeiPerWorkloadResponse struct {
	Code int                    `json:"code,omitempty"`
	Msg  string                 `json:"msg,omitempty"`
	Data []WeiPerWorkloadStruct `json:"data,omitempty"`
}

type TotalRevenuesRequest struct {
	Address string `json:"address,omitempty"`
}

type TotalRevenuesStruct struct {
	Total     string `json:"total"`
	Claimed   string `json:"claimed"`
	Unclaimed string `json:"unclaimed"`
}

type TotalRevenuesResponse struct {
	Code int                 `json:"code"`
	Msg  string              `json:"msg"`
	Data TotalRevenuesStruct `json:"data"`
}

type WithdrawalRecordRequest struct {
	Address  string `json:"address,omitempty"`
	Page     int    `json:"page,omitempty"`
	PageSize int    `json:"pageSize,omitempty"`
}

type WithdrawalRecordStruct struct {
	TxHash    string `json:"txHash"`
	Date      string `json:"date"`
	Timestamp int    `json:"timestamp"`
	Amount    string `json:"amount"`
}

type WithdrawalRecordData struct {
	TotalCount int                      `json:"totalCount"`
	Records    []WithdrawalRecordStruct `json:"records"`
}

type WithdrawalRecordResponse struct {
	Code int                  `json:"code"`
	Msg  string               `json:"msg"`
	Data WithdrawalRecordData `json:"data"`
}
