package controllers

import (
	"ai_developer_admin/libs/mysql"
	"ai_developer_admin/models"
	"encoding/json"
	"github.com/beego/beego/v2/core/logs"
	"net/http"
	"time"
)

type UserLevelController struct {
	MainController
}

func (server *UserLevelController) Levels() {
	_, err := server.Check()
	if err != nil {
		server.respond(http.StatusUnauthorized, err.Error())
		return
	}
	body := server.Ctx.Input.RequestBody
	appRequest := models.AppRequest{}
	err = json.Unmarshal(body, &appRequest) //解析body中数据
	logs.Debug("appRequest", appRequest, string(body))
	//if err != nil {
	//	server.respond(models.NoRequestBody, err.Error())
	//	return
	//}

	if appRequest.Page == 0 {
		appRequest.Page = 1
	}

	if appRequest.Size == 0 {
		appRequest.Size = 10
	}
	offset := (appRequest.Page - 1) * appRequest.Size

	qs := mysql.GetMysqlInstace().Ormer.QueryTable("user_level").Filter("deleted", 0)
	infoQs := qs.Offset(offset).Limit(appRequest.Size)
	count, err := infoQs.Count()
	logs.Debug("Levels = ", count)
	var levels []*models.UserLevel
	if count > 0 {
		infoQs.All(&levels)
		for _, data := range levels {
			data.Price = data.Price / 1000000
			data.DiscountedPrice = data.DiscountedPrice / 1000000
			data.CreditQuota = data.CreditQuota / 1000000
		}
	}
	total, err := qs.Count()
	responseData := struct {
		Total int64       `json:"total"`
		Data  interface{} `json:"data,omitempty"`
	}{
		Total: total,
		Data:  levels,
	}
	server.respond(http.StatusOK, "", responseData)
}

func (server *UserLevelController) AddLevel() {
	_, err := server.Check()
	if err != nil {
		server.respond(http.StatusUnauthorized, err.Error())
		return
	}
	body := server.Ctx.Input.RequestBody
	logs.Debug("AddLevel body", string(body))
	request := models.UserLevel{}
	err = json.Unmarshal(body, &request) //解析body中数据
	logs.Debug("request", request)
	if err != nil {
		server.respond(models.NoRequestBody, err.Error())
		return
	}
	//if request.Level == 0 {
	//	u.respond(models.MissingParameter, "level 不能为空且必须大于0")
	//	return
	//}
	qs := mysql.GetMysqlInstace().Ormer.QueryTable("user_level")
	usernameQs := qs.Filter("level", request.Level)
	count, err := usernameQs.Count()
	logs.Debug("Levels = ", count)
	//var levels []*models.UserLevel
	if count > 0 {
		server.respond(models.BusinessFailed, "level is exist")
		return
	}

	timestamp := time.Now()

	request.CreditQuota = request.CreditQuota * 1000000
	request.Price = request.Price * 1000000
	request.DiscountedPrice = request.DiscountedPrice * 1000000
	request.CreatedTime = timestamp
	request.UpdatedTime = timestamp
	request.Deleted = 0

	_, err = mysql.GetMysqlInstace().Ormer.Insert(&request)
	if err != nil {
		server.respond(models.BusinessFailed, err.Error())
		return
	}

	server.respond(http.StatusOK, "")
}

func (server *UserLevelController) UpdateLevel() {
	_, err := server.Check()
	if err != nil {
		server.respond(http.StatusUnauthorized, err.Error())
		return
	}
	body := server.Ctx.Input.RequestBody
	logs.Debug("AddLevel body", string(body))
	request := models.UserLevel{}
	err = json.Unmarshal(body, &request) //解析body中数据
	logs.Debug("request", request)
	if err != nil {
		server.respond(models.NoRequestBody, err.Error())
		return
	}

	if request.Id == 0 {
		server.respond(models.MissingParameter, "Missing id parameter")
		return
	}

	checkLevel := models.UserLevel{Id: request.Id}
	err = mysql.GetMysqlInstace().Ormer.Read(&checkLevel)
	if err != nil {
		server.respond(models.BusinessFailed, "level not exist")
		return
	}
	if checkLevel.Level != request.Level {
		server.respond(models.BusinessFailed, "cannot modify level field")
		return
	}

	request.CreditQuota = request.CreditQuota * 1000000
	request.Price = request.Price * 1000000
	request.DiscountedPrice = request.DiscountedPrice * 1000000
	request.CreatedTime = checkLevel.CreatedTime
	request.UpdatedTime = time.Now()
	_, err = mysql.GetMysqlInstace().Ormer.Update(&request)
	if err != nil {
		server.respond(models.BusinessFailed, "failed")
		return
	}

	server.respond(http.StatusOK, "success")
}

func (server *UserLevelController) DelLevel() {
	_, err := server.Check()
	if err != nil {
		server.respond(http.StatusUnauthorized, err.Error())
		return
	}
	body := server.Ctx.Input.RequestBody
	logs.Debug("AddLevel body", string(body))
	request := models.UserLevel{}
	err = json.Unmarshal(body, &request) //解析body中数据
	logs.Debug("request", request)
	if err != nil {
		server.respond(models.NoRequestBody, err.Error())
		return
	}

	if request.Id == 0 {
		server.respond(models.MissingParameter, "Missing id parameter")
		return
	}

	if request.Level == 0 {
		server.respond(models.MissingParameter, "cannot delete 0 level")
		return
	}
	request.Deleted = 1

	mysql.GetMysqlInstace().Ormer.Update(&request)
	server.respond(http.StatusOK, "success")
}
