package models

import (
	"time"
)

//type App struct {
//	Id            int       `orm:"column(id);auto"`
//	ApiKey        string    `json:"api_key";orm:"column(api_key);size(255)"`
//	JwtCredential string    `json:"jwt_credential";orm:"column(jwt_credential)"`
//	JwtToken      string    `json:"jwt_token";orm:"column(jwt_token)"`
//	UserId        int       `json:"user_id";orm:"column(user_id)"`
//	CreatedTime   time.Time `json:"created_time";orm:"column(created_time);type(datetime)"`
//	UpdatedTime   time.Time `json:"updated_time";orm:"column(updated_time);type(datetime)"`
//	Deleted       int       `json:"deleted";orm:"column(deleted);size(1)"`
//}

type ApiKey struct {
	Id          int       `orm:"column(id);auto"`
	Name        string    `json:"name,omitempty";orm:"column(name)"`
	ApiKey      string    `json:"api_key";orm:"column(api_key);size(255)"`
	ApiKeyId    string    `json:"api_key_id";orm:"column(api_key_id);size(255)"`
	UserId      int       `json:"user_id";orm:"column(user_id)"`
	CreatedTime time.Time `json:"created_time";orm:"column(created_time);type(datetime)"`
	UpdatedTime time.Time `json:"updated_time";orm:"column(updated_time);type(datetime)"`
	Deleted     int       `json:"deleted";orm:"column(deleted);size(1)"`
}

type JwtToken struct {
	Id            int       `orm:"column(id);auto"`
	Name          string    `json:"name,omitempty";orm:"column(name)"`
	JwtCredential string    `json:"jwt_credential,omitempty";orm:"column(jwt_credential)"`
	JwtToken      string    `json:"jwt_token";orm:"column(jwt_token)"`
	JwtId         string    `json:"jwt_id";orm:"column(jwt_id)"`
	UserId        int       `json:"user_id";orm:"column(user_id)"`
	CreatedTime   time.Time `json:"created_time";orm:"column(created_time);type(datetime)"`
	UpdatedTime   time.Time `json:"updated_time";orm:"column(updated_time);type(datetime)"`
	Deleted       int       `json:"deleted";orm:"column(deleted);size(1)"`
}

type AppRequest struct {
	Id   int    `json:"id,omitempty"`
	Name string `json:"name,omitempty"`

	// 通用
	Page      int64  `json:"page,omitempty"`
	Size      int64  `json:"size,omitempty"`
	StartTime string `json:"start_time,omitempty"`
	EndTime   string `json:"end_time,omitempty"`
	// 消费明细/任务查询
	ProfitAcc    string `json:"profit_acc,omitempty"`
	WorkerAcc    string `json:"worker_acc,omitempty"`
	FeeCondition int    `json:"fee_condition,omitempty"`
	Fee          int    `json:"fee,omitempty"`
	// 收支明细
	TradeFlow    int `json:"trade_flow,omitempty"` // int
	TradeType    int `json:"trade_type,omitempty"`
	TradeChannel int `json:"trade_channel,omitempty"`

	// 模型模糊查询
	Keyword  string `json:"keyword,omitempty"`
	Category int    `json:"category,omitempty"`

	//显卡列表
	Type int `json:"type,omitempty"`
}

type EnumType struct {
	Id     int    `json:"id"`
	Desc   string `json:"desc"`
	EnDesc string `json:"en_desc"`
}
