package cronjob

import (
	"ai_developer_admin/libs/mysql"
	"ai_developer_admin/libs/postgres"
	"ai_developer_admin/libs/redis"
	"ai_developer_admin/libs/registry"
	"ai_developer_admin/libs/snowflake"
	"ai_developer_admin/models"
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"github.com/beego/beego/v2/core/logs"
	beego "github.com/beego/beego/v2/server/web"
	qdb "github.com/questdb/go-questdb-client/v2"
	"github.com/robfig/cron/v3"
	"io"
	"net/http"
	"sort"
	"strconv"
	"strings"
	"time"
)

var loopCronTask = cron.New(cron.WithSeconds())
var debitTask = cron.New(cron.WithSeconds())
var revenueTask = cron.New(cron.WithSeconds())
var registryTask = cron.New(cron.WithSeconds())

var HeatKey = "task:heat"

var format = "2006-01-02T15:04:05.000000Z"

func Start() {
	//defer loopCronTask.Stop()
	startHeatKey()
	startDebit()
	startRevenue()
	//startRegistBackend()
}

func findTaskCount(counts []models.TaskCount, id string) int {
	for _, value := range counts {
		if strings.Compare(value.Type, id) == 0 {
			count, _ := strconv.Atoi(value.Count)
			return count
		}
	}
	return 0
}

func startHeatKey() {
	//spec := "0 0 * * * ?" //"@every 1h"
	spec := "@every 1h" //"@every 1h"
	//spec := "*/1 * * * * ?" //"@every 1h"
	loopCronTask.AddFunc(spec, func() {
		logs.Debug("loopCronTask")
		qs := mysql.GetMysqlInstace().Ormer.QueryTable("task_type")
		count, _ := qs.Count()
		logs.Debug("types = ", count)
		var types []*models.TaskType
		if count > 0 {
			qs.All(&types)
		} else {
			return
		}

		sql := "SELECT type,count(type) FROM bills GROUP BY type ORDER BY count DESC;"
		tasks, err := postgres.CountTasks(sql)
		//if err != nil {
		//	return
		//}
		//dataString, err := redis.GetDataToString(HeatKey)
		var response []*models.TaskHeat
		//if err != nil {
		//	return
		//}
		//err = json.Unmarshal([]byte(dataString), &response)
		//if err != nil {
		//	return
		//}

		for _, dbType := range types {
			var hardwareRequire interface{}
			eer := json.Unmarshal([]byte(dbType.HardwareRequire), &hardwareRequire)
			if eer != nil {

			}
			var output interface{}
			if dbType.Form != "" {
				err := json.Unmarshal([]byte(dbType.Form), &output)
				if err != nil {
					logs.Debug("Form Unmarshal err")
				}
			}
			heat := findTaskCount(tasks, strconv.Itoa(dbType.Id))
			retask := models.TaskHeat{
				TaskId:          dbType.Id,
				User:            dbType.Username,
				Pwd:             dbType.Password,
				Repository:      dbType.ImageUrl,
				SignUrl:         dbType.SignUrl,
				ImageName:       dbType.ImageName,
				ImageId:         dbType.ImageId,
				HardwareRequire: hardwareRequire,
				Count:           int64(heat),
				Kind:            dbType.Kind,
				FileExpiresTime: strconv.Itoa(dbType.ResultFileExpires),
				OutPutJson:      output,
				AccessStatus:    dbType.AccessStatus,
				PublishStatus:   dbType.PublishStatus,
				EstimatExeTime:  dbType.EstimatExeTime,
				StartUpTime:     dbType.StartUpTime,
				RunningMem:      dbType.RunningMem,
			}
			response = append(response, &retask)
		}

		//for _, value := range tasks {
		//	taskId, err := strconv.Atoi(value.Type)
		//	if err != nil {
		//		continue
		//	}
		//	count, _ := strconv.Atoi(value.Count)
		//	for _, taskType := range response {
		//		if taskType.TaskId == taskId {
		//			taskType.Count = int64(count)
		//		}
		//	}
		//}
		//for _, value := range tasks {
		//	taskId, err := strconv.Atoi(value.Type)
		//	if err != nil {
		//		continue
		//	}
		//	taskType, err1 := odysseus.GetTaskType(int64(taskId))
		//	if err1 != nil {
		//		continue
		//	}
		//	var hardwareRequire models.Hardware
		//	eer := json.Unmarshal([]byte(taskType.HardwareRequire), &hardwareRequire)
		//	if eer != nil {
		//
		//	}
		//	count, _ := strconv.Atoi(value.Count)
		//	retask := models.TaskHeat{
		//		TaskId:          taskId,
		//		User:            taskType.Username,
		//		Pwd:             taskType.Password,
		//		Repository:      taskType.ImageUrl,
		//		SignUrl:         taskType.SignUrl,
		//		ImageName:       taskType.ImageName,
		//		ImageId:         taskType.ImageId,
		//		HardwareRequire: hardwareRequire,
		//		Count:           int64(count),
		//	}
		//	response = append(response, retask)
		//}
		sort.Slice(response, func(i, j int) bool {
			return response[i].Count > response[j].Count
		})
		data, err := json.Marshal(response)
		if err == nil {
			redis.SetKeyAndData(HeatKey, string(data), 0)
		}
	})
	loopCronTask.Start()
}

func startDebit() {
	logs.Debug("startDebit")
	//spec := "*/50 */23 * * * ?" //"@every 1h"
	//spec := "01 01 00 * * ?"
	spec, _ := beego.AppConfig.String("debitTime")
	//spec := "@every 1m"
	dbhost, _ := beego.AppConfig.String("postgreshost")
	dbport, _ := beego.AppConfig.Int("senderport")

	questAddr := fmt.Sprintf("%s:%d", dbhost, dbport)
	debitTask.AddFunc(spec, func() {
		logs.Debug("startDebit debitTask")
		ctx := context.TODO()
		addrOpt := qdb.WithAddress(questAddr)
		sender, err := qdb.NewLineSender(ctx, addrOpt)

		if err != nil {
			logs.Debug("startDebit NewLineSender = %s", err.Error())
			return
		}
		defer sender.Close()
		// Make sure to close the sender on exit to release resources.

		currentTime := time.Now()
		temp := fmt.Sprintf("-%dh", 2)
		m, _ := time.ParseDuration(temp)
		dayTime := currentTime.Add(m)
		endTime := time.Date(dayTime.Year(), dayTime.Month(), dayTime.Day(), 23, 59, 59, 0, time.UTC)
		startTime := time.Date(dayTime.Year(), dayTime.Month(), dayTime.Day(), 0, 0, 0, 0, time.UTC)
		start := fmt.Sprintf(startTime.Format(format))
		end := fmt.Sprintf(endTime.Format(format))

		logs.Debug("startDebit before sql = %s", dayTime)

		sql := fmt.Sprintf("SELECT time, uid,sum(fee) AS amount FROM bills WHERE uid != '0' and time >= '%s' and time <= '%s' SAMPLE BY 1d ALIGN TO CALENDAR GROUP BY uid,time;", start, end)
		data, err := postgres.CountFunds(sql)
		if err != nil {
			logs.Debug("startDebit postgres CountFunds = %s", err.Error())
			return
		}
		if data == nil {
			logs.Debug("startDebit data = nil")
			return
		}

		//sql = "SELECT Max(id) AS count FROM funds;"
		//max, err := postgres.QueryTotal(sql)
		//if err != nil {
		//	return
		//}

		for _, fund := range data {
			//tradeTime, _ := time.Parse(fund.Time, format)
			id, _ := snowflake.NextId()

			uid, _ := strconv.Atoi(fund.Uid)
			amount, _ := strconv.ParseInt(fund.Amount, 10, 64)

			nanoseconds := int64(uint64(dayTime.UnixNano()))
			seconds := nanoseconds / 1e9

			order, _ := snowflake.NextId()
			orderId := strconv.FormatInt(int64(order), 10)

			err = sender.Table("funds").
				Symbol("order_id", orderId).
				Symbol("remark", "").
				Symbol("channel_serial", "").
				Int64Column("uid", int64(uid)).
				Int64Column("amount", int64(amount)).
				Int64Column("balance", 0).
				Int64Column("trade_channel", 0).
				Int64Column("status", 5).
				Int64Column("id", int64(id)).
				TimestampColumn("trade_time", time.Unix(seconds, nanoseconds%1e9)).
				Int64Column("trade_flow", int64(models.Expenditure)).
				Int64Column("trade_type", int64(models.Spending)).
				AtNow(ctx)

			if err != nil {
				logs.Debug("startDebit sender = %s,id = %d", err.Error(), id)
			}
			//break
		}

		err = sender.Flush(ctx)
		if err != nil {
			logs.Debug("startDebit Flush = %s", err.Error())
		}
	})
	debitTask.Start()
}

func startRevenue() {
	logs.Debug("startRevenue")
	//spec := "*/50 */23 * * * ?" //"@every 1h"
	//spec := "01 01 00 * * ?"
	//spec, _ := beego.AppConfig.String("debitTime")
	//spec := "@every 1m"
	spec := "@every 1h"
	//dbhost, _ := beego.AppConfig.String("postgreshost")
	//dbport, _ := beego.AppConfig.Int("senderport")

	//questAddr := fmt.Sprintf("%s:%d", dbhost, dbport)
	revenueTask.AddFunc(spec, func() {
		logs.Debug("startRevenue revenueTask")

		total, multipliers, err := checkMultiplier()
		if err != nil {
			return
		}
		var dates []string
		for _, value := range multipliers {
			temp := fmt.Sprintf("+%dh", 24)
			m, _ := time.ParseDuration(temp)
			time := value.Time.Add(m)
			date := fmt.Sprintf(time.Format("2006-01-02"))
			dates = append(dates, date)
		}
		if total <= 0 {
			dates = checkDate()
		}
		reaponse, err := getWeiPerWorkload(dates)
		if err != nil {
			return
		}
		err = insertMultiplier(reaponse)
		if err != nil {
			return
		}

		//ctx := context.TODO()
		//addrOpt := qdb.WithAddress(questAddr)
		//sender, err := qdb.NewLineSender(ctx, addrOpt)
		//
		//if err != nil {
		//	logs.Debug("startRevenue NewLineSender = %s", err.Error())
		//	return
		//}
		//defer sender.Close()
		// Make sure to close the sender on exit to release resources.

		//temp, _ := time.Parse("2006-01-02", value.Date)
		//startTime :=
		//endTime := time.Date(dayTime.Year(), dayTime.Month(), dayTime.Day(), 23, 59, 59, 0, time.UTC)
		//startTime := time.Date(dayTime.Year(), dayTime.Month(), dayTime.Day(), 0, 0, 0, 0, time.UTC)
		//start := fmt.Sprintf(startTime.Format(format))
		//end := fmt.Sprintf(endTime.Format(format))

		//logs.Debug("startRevenue before sql = %s", dayTime)

		//sql := fmt.Sprintf("SELECT id,time,type,workload,profit_acc,worker_acc FROM bills WHERE time >= '%s' and time <= '%s';", start, end)
		//data, err := postgres.QueryBills(sql)
		//if err != nil {
		//	logs.Debug("startRevenue postgres CountFunds = %s", err.Error())
		//	return
		//}
		//if data == nil {
		//	logs.Debug("startRevenue data = nil")
		//	return
		//}

		//for _, bill := range data {
		//
		//	//nanoseconds := int64(uint64(dayTime.UnixNano()))
		//	//seconds := nanoseconds / 1e9
		//
		//	taskId := bill.Type
		//	typeDesc := ""
		//	baseModel := ""
		//	if err == nil {
		//		taskType, err1 := odysseus.GetTaskType(int64(taskId))
		//		if err1 == nil {
		//			typeDesc = models.ModelType(taskType.Type).String()
		//			baseModel = taskType.BaseModel
		//		}
		//	}
		//
		//	err = sender.Table("revenues").
		//		Symbol("id", bill.Id).
		//		Symbol("type", typeDesc).
		//		Symbol("base_model", baseModel).
		//		Symbol("profit_acc", bill.ProfitAcc).
		//		Symbol("worker_acc", bill.WorkerAcc).
		//		Int64Column("workload", bill.Workload).
		//		Int64Column("income", int64(0)).
		//		TimestampColumn("time", bill.Time).
		//		AtNow(ctx)
		//
		//	if err != nil {
		//		logs.Debug("startRevenue sender = %s,id = %d", err.Error(), bill.Id)
		//	}
		//	//break
		//}
		//
		//err = sender.Flush(ctx)
		//if err != nil {
		//	logs.Debug("startRevenue Flush = %s", err.Error())
		//}
	})
	revenueTask.Start()
}

func checkDate() []string {
	sql := "SELECT count(*),time FROM bills SAMPLE BY 1d ALIGN TO CALENDAR ORDER BY time DESC;"
	date, err := postgres.QueryBills(sql)
	if err != nil {
		return nil
	}
	var dates []string
	for _, value := range date {
		dateString := fmt.Sprintf(value.Time.Format("2006-01-02"))
		dates = append(dates, dateString)
	}
	return dates
}

func getWeiPerWorkload(dates []string) ([]models.WeiPerWorkloadStruct, error) {
	host, _ := beego.AppConfig.String("rewardUrl")
	url := host + "/api/v1/workload"
	payload := new(bytes.Buffer)
	json.NewEncoder(payload).Encode(dates)
	//if len(dates) <= 0 {
	//	payload = nil
	//}
	resp, err := http.Post(url, "application/json;charset=UTF-8", payload)
	if err != nil {
		logs.Info("Error sending request:", err)
		return nil, err
	}
	defer resp.Body.Close()
	logs.Info("getWeiPerWorkload resp code", resp.StatusCode)
	body, err := io.ReadAll(resp.Body)
	if err != nil {
		logs.Info("Error reading response:", err)
		return nil, err
	}
	var response models.WeiPerWorkloadResponse
	if err := json.Unmarshal(body, &response); err != nil {
		logs.Info("Error Unmarshal response:", err)
		return nil, err
	}
	return response.Data, nil
}

func checkMultiplier() (int64, []models.Revenues, error) {
	sql := "SELECT count(*) FROM reward_multiplier;"
	total, err := postgres.QueryTotal(sql)
	if total <= 0 {
		return total, nil, err
	}
	sql = "SELECT * FROM reward_multiplier ORDER BY time DESC LIMIT 0,1;"
	data, err := postgres.QueryRevenues(sql)
	return total, data, err
}

func insertMultiplier(data []models.WeiPerWorkloadStruct) error {
	if len(data) <= 0 {
		return errors.New("data len < 0")
	}
	dbhost, _ := beego.AppConfig.String("postgreshost")
	dbport, _ := beego.AppConfig.Int("senderport")

	questAddr := fmt.Sprintf("%s:%d", dbhost, dbport)
	ctx := context.TODO()
	addrOpt := qdb.WithAddress(questAddr)
	sender, err := qdb.NewLineSender(ctx, addrOpt)

	if err != nil {
		logs.Debug("startRevenue NewLineSender = %s", err.Error())
		return err
	}
	defer sender.Close()
	currentTime := time.Now()
	currentTime = time.Date(currentTime.Year(), currentTime.Month(), currentTime.Day(), 0, 0, 0, 0, time.UTC)
	for _, value := range data {
		temp, _ := time.Parse("2006-01-02", value.Date)
		if strings.Compare(value.WeiPerWorkload, "0") == 0 && temp.Compare(currentTime) >= 0 {
			continue
		}

		nanoseconds := int64(uint64(temp.UnixNano()))
		seconds := nanoseconds / 1e9

		id, _ := snowflake.NextId()
		err = sender.Table("reward_multiplier").
			Symbol("wei", value.WeiPerWorkload).
			Int64Column("id", int64(id)).
			TimestampColumn("time", time.Unix(seconds, nanoseconds%1e9)).
			AtNow(ctx)

		if err != nil {
			logs.Debug("startRevenue sender = %s,id = %d", err.Error())
			return err
		}
		//break
	}

	err = sender.Flush(ctx)
	if err != nil {
		logs.Debug("startRevenue Flush = %s", err.Error())
		return err
	}

	return nil
}

func startRegistBackend() {
	spec := "@every 1m"
	registryTask.AddFunc(spec, func() {
		logs.Debug("startRegistBackend")
		registry.RegistryBackend()
	})
	debitTask.Start()
}

//func Start() {
//	//defer loopCronTask.Stop()
//
//	spec := "*/1 * * * * ?" //"@every 1h"
//	loopCronTask.AddFunc(spec, func() {
//		logs.Debug("loopCronTask")
//		//sql := "SELECT type,count(type) FROM bills GROUP BY type ORDER BY count DESC;"
//		//tasks, err := postgres.CountTasks(sql)
//		//if err != nil {
//		//	return
//		//}
//		var response []models.TaskHeat
//		//for _, value := range tasks {
//		//	taskId, err := strconv.Atoi(value.Type)
//		//	if err != nil {
//		//		continue
//		//	}
//		taskType, err1 := odysseus.GetTaskType(int64(12))
//		if err1 != nil {
//			//continue
//		}
//		var hardwareRequire models.Hardware
//		eer := json.Unmarshal([]byte(taskType.HardwareRequire), &hardwareRequire)
//		if eer != nil {
//
//		}
//		//count, _ := strconv.Atoi(value.Count)
//		retask := models.TaskHeat{
//			TaskId:          12,
//			User:            taskType.Username,
//			Pwd:             taskType.Password,
//			Repository:      taskType.ImageUrl,
//			SignUrl:         taskType.SignUrl,
//			ImageName:       taskType.ImageName,
//			ImageId:         taskType.ImageId,
//			HardwareRequire: hardwareRequire,
//			Count:           int64(0),
//		}
//		response = append(response, retask)
//		//}
//		data, err := json.Marshal(response)
//		if err == nil {
//			redis.SetKeyAndData("task:heat", string(data), 0)
//		}
//	})
//	loopCronTask.Start()
//}
