package snowflake

import (
	"github.com/sony/sonyflake"
	"time"
)
import "github.com/beego/beego/v2/core/logs"
import "errors"

var flake *sonyflake.Sonyflake

func init() {
	flake = sonyflake.NewSonyflake(sonyflake.Settings{
		MachineID: func() (uint16, error) {
			return 1, nil
		},
		StartTime: time.Now(),
	}) // New(sonyflake.Settings{})
	if flake == nil {
		logs.Error("failed to create Sonyflake,")
	}
}

func NextId() (uint64, error) {
	if flake == nil {
		logs.Error("failed to create Sonyflake,")
		return 0, errors.New("failed to create Sonyflake")
	}
	return flake.NextID()
}
