package controllers

import (
	"ai_developer_admin/libs/ipgeo"
	"ai_developer_admin/libs/mysql"
	"ai_developer_admin/libs/postgres"
	"ai_developer_admin/libs/registry"
	"ai_developer_admin/models"
	"bytes"
	"encoding/json"
	"fmt"
	"github.com/beego/beego/orm"
	"github.com/beego/beego/v2/core/logs"
	beego "github.com/beego/beego/v2/server/web"
	"io"
	"math/big"
	"net/http"
	"strconv"
	"time"
)

type ClientController struct {
	MainController
}

func (server *ClientController) GlobalStatistics() {
	body := server.Ctx.Input.RequestBody
	appRequest := models.AppRequest{}
	err := json.Unmarshal(body, &appRequest) //解析body中数据
	logs.Debug("appRequest", appRequest)
	if err != nil {
		server.respond(models.NoRequestBody, err.Error())
		return
	}
	//if appRequest.WorkerAcc == "" {
	//	server.respond(models.MissingParameter, "Missing worker_acc parameter")
	//	return
	//}

	countQB, _ := orm.NewQueryBuilder("mysql")
	countQB.Select("count(*),sum(workload) AS workload").
		From("bills")
	sql := countQB.String()
	taskCount, err := postgres.QueryBills(sql)
	if err != nil {
		server.respond(models.BusinessFailed, err.Error())
		return
	}

	count := int64(0)
	workload := int64(0)
	if len(taskCount) > 0 {
		task := taskCount[0]
		count = task.Count
		workload = task.Workload
	}

	_, total, _ := registry.NodeManagersByPage(0, 10)

	responseData := struct {
		TotalWorkload int64 `json:"total_workload"`
		TotalTask     int64 `json:"total_task"`
		//TotalCalls    int64 `json:"total_calls"`
		NodeNums int `json:"node_nums"`
	}{
		TotalWorkload: workload,
		TotalTask:     count,
		//TotalCalls:    count,
		NodeNums: total,
	}
	server.respond(http.StatusOK, "", responseData)
}

func (server *ClientController) Statistics() {
	body := server.Ctx.Input.RequestBody
	appRequest := models.AppRequest{}
	err := json.Unmarshal(body, &appRequest) //解析body中数据
	logs.Debug("appRequest", appRequest)
	if err != nil {
		server.respond(models.NoRequestBody, err.Error())
		return
	}
	if appRequest.WorkerAcc == "" {
		server.respond(models.MissingParameter, "Missing worker_acc parameter")
		return
	}

	countQB, _ := orm.NewQueryBuilder("mysql")
	countQB.Select("count(*)").
		From("bills").Where(fmt.Sprintf("worker_acc = '%s'", appRequest.WorkerAcc))
	sql := countQB.String()
	count, err := postgres.QueryTotal(sql)
	if err != nil {
		server.respond(models.BusinessFailed, err.Error())
		return
	}

	sumQB, _ := orm.NewQueryBuilder("mysql")
	sumQB.Select("sum(workload)").
		From("bills").Where(fmt.Sprintf("worker_acc = '%s'", appRequest.WorkerAcc))
	sql = sumQB.String()
	workload, err := postgres.QueryTotal(sql)

	//currentTime := time.Now()
	//endTime := time.Date(currentTime.Year(), currentTime.Month(), currentTime.Day(), 23, 59, 59, 0, time.UTC)
	//temp := fmt.Sprintf("-%dh", 24*7)
	//m, _ := time.ParseDuration(temp)
	//tempTime := currentTime.Add(m)
	//startTime := time.Date(tempTime.Year(), tempTime.Month(), tempTime.Day(), 0, 0, 0, 0, time.UTC)
	//
	//start := fmt.Sprintf(startTime.Format(format))
	//end := fmt.Sprintf(endTime.Format(format))

	//YCountQB, _ := orm.NewQueryBuilder("mysql")
	//YCountQB.Select("count(*)").
	//	From("bills").Where(fmt.Sprintf("worker_acc = '%s'", appRequest.WorkerAcc)).
	//	And(fmt.Sprintf("time >= '%s'", start)).And(fmt.Sprintf("time <= '%s'", end))
	//sql = YCountQB.String()
	//YCount, err := postgres.QueryTotal(sql)
	//if err != nil {
	//	server.respond(models.BusinessFailed, err.Error())
	//	return
	//}

	//YSumQB, _ := orm.NewQueryBuilder("mysql")
	//YSumQB.Select("sum(workload)").
	//	From("bills").Where(fmt.Sprintf("worker_acc = '%s'", appRequest.WorkerAcc)).
	//	And(fmt.Sprintf("time >= '%s'", start)).And(fmt.Sprintf("time <= '%s'", end))
	//sql = YSumQB.String()
	//YWorkload, err := postgres.QueryTotal(sql)

	responseData := struct {
		TotalWorkload int64 `json:"total_workload"`
		TotalTask     int64 `json:"total_task"`
		//YesterdayWorkload int64 `json:"yesterday_workload"`
		//YesterdayTask     int64 `json:"yesterday_task"`
	}{
		TotalWorkload: workload,
		TotalTask:     count,
		//YesterdayWorkload: YWorkload,
		//YesterdayTask:     YCount,
	}
	server.respond(http.StatusOK, "", responseData)
}

func (server *ClientController) TasksPerDay() {

	body := server.Ctx.Input.RequestBody
	appRequest := models.AppRequest{}
	err := json.Unmarshal(body, &appRequest) //解析body中数据
	logs.Debug("appRequest", appRequest)

	if appRequest.Page == 0 {
		appRequest.Page = 1
	}
	if appRequest.Size == 0 {
		appRequest.Size = 10
	}
	offset := (appRequest.Page - 1) * appRequest.Size
	size := appRequest.Page * appRequest.Size

	if appRequest.WorkerAcc == "" && appRequest.ProfitAcc == "" {
		server.respond(models.MissingParameter, "At least one of worker_acc or profit_acc needs to be passed.")
		return
	}

	countQB, _ := orm.NewQueryBuilder("mysql")
	countQB.Select("count(*)").
		From("bills")

	queryQB, _ := orm.NewQueryBuilder("mysql")
	queryQB.Select("count(*) AS total_tasks", "sum(workload) AS total_workload", "sum(exec_duration) AS exec_duration", "time").
		From("bills")

	if appRequest.WorkerAcc != "" {
		countQB.Where(fmt.Sprintf("worker_acc = '%s'", appRequest.WorkerAcc))
		queryQB.Where(fmt.Sprintf("worker_acc = '%s'", appRequest.WorkerAcc))
	}
	if appRequest.ProfitAcc != "" && appRequest.WorkerAcc == "" {
		countQB.Where(fmt.Sprintf("profit_acc = '%s'", appRequest.ProfitAcc))
		queryQB.Where(fmt.Sprintf("profit_acc = '%s'", appRequest.ProfitAcc))
	}
	if appRequest.ProfitAcc != "" && appRequest.WorkerAcc != "" {
		countQB.And(fmt.Sprintf("profit_acc = '%s'", appRequest.ProfitAcc))
		queryQB.And(fmt.Sprintf("profit_acc = '%s'", appRequest.ProfitAcc))
	}

	if appRequest.StartTime != "" && appRequest.EndTime != "" {
		temp, _ := time.Parse(layout, appRequest.StartTime)
		startTime := fmt.Sprintf(temp.Format(format))
		temp, _ = time.Parse(layout, appRequest.EndTime)
		endTime := fmt.Sprintf(temp.Format(format))
		countQB.And(fmt.Sprintf("time >= '%s'", startTime)).And(fmt.Sprintf("time <= '%s'", endTime))
		queryQB.And(fmt.Sprintf("time >= '%s'", startTime)).And(fmt.Sprintf("time <= '%s'", endTime))
	}

	sql := fmt.Sprintf("%s SAMPLE BY 1d ALIGN TO CALENDAR", countQB.String())
	sql = fmt.Sprintf("SELECT count(*) FROM (%s);", sql)

	total, err := postgres.QueryTotal(sql)
	if err != nil {
		server.respond(models.BusinessFailed, err.Error())
		return
	}
	logs.Debug("total = %d", total)
	var responseTasks []models.Bills
	if total == 0 {
		responseData := struct {
			Total int64       `json:"total"`
			Data  interface{} `json:"data,omitempty"`
		}{
			Total: total,
			Data:  responseTasks,
		}
		server.respond(http.StatusOK, "", responseData)
		return
	}

	//queryQB.OrderBy("time").Desc()
	sql = fmt.Sprintf("%s SAMPLE BY 1d ALIGN TO CALENDAR ORDER BY time DESC LIMIT %d,%d;", queryQB.String(), offset, size)
	counts, err := postgres.QueryBills(sql)
	if err != nil {
		server.respond(models.BusinessFailed, err.Error())
		return
	}
	responseData := struct {
		Total int64       `json:"total"`
		Data  interface{} `json:"data,omitempty"`
	}{
		Total: total,
		Data:  counts,
	}
	server.respond(http.StatusOK, "", responseData)
}

func (server *ClientController) GlobalTasksPerDay() {

	body := server.Ctx.Input.RequestBody
	appRequest := models.AppRequest{}
	err := json.Unmarshal(body, &appRequest) //解析body中数据
	logs.Debug("appRequest", body, appRequest)

	if appRequest.Page == 0 {
		appRequest.Page = 1
	}
	if appRequest.Size == 0 {
		appRequest.Size = 10
	}
	offset := (appRequest.Page - 1) * appRequest.Size
	size := appRequest.Page * appRequest.Size

	//if appRequest.WorkerAcc == "" && appRequest.ProfitAcc == "" {
	//	server.respond(models.MissingParameter, "At least one of worker_acc or profit_acc needs to be passed.")
	//	return
	//}

	countQB, _ := orm.NewQueryBuilder("mysql")
	countQB.Select("count(*)").
		From("bills")

	queryQB, _ := orm.NewQueryBuilder("mysql")
	queryQB.Select("count(*) AS total_tasks,sum(workload) AS total_workload", "sum(exec_duration) AS exec_duration", "time").
		From("bills")

	//if appRequest.WorkerAcc != "" {
	//	countQB.Where(fmt.Sprintf("worker_acc = '%s'", appRequest.WorkerAcc))
	//	queryQB.Where(fmt.Sprintf("worker_acc = '%s'", appRequest.WorkerAcc))
	//}
	//if appRequest.ProfitAcc != "" && appRequest.WorkerAcc == "" {
	//	countQB.Where(fmt.Sprintf("profit_acc = '%s'", appRequest.ProfitAcc))
	//	queryQB.Where(fmt.Sprintf("profit_acc = '%s'", appRequest.ProfitAcc))
	//}
	//if appRequest.ProfitAcc != "" && appRequest.WorkerAcc != "" {
	//	countQB.And(fmt.Sprintf("profit_acc = '%s'", appRequest.ProfitAcc))
	//	queryQB.And(fmt.Sprintf("profit_acc = '%s'", appRequest.ProfitAcc))
	//}

	if appRequest.StartTime != "" && appRequest.EndTime != "" {
		//temp, _ := time.Parse("2006-01-02T15:04:05Z", appRequest.StartTime)
		//startTime := fmt.Sprintf(temp.Format(format))
		//temp, _ = time.Parse(layout, appRequest.EndTime)
		//endTime := fmt.Sprintf(temp.Format(format))
		countQB.Where(fmt.Sprintf("time >= '%s'", appRequest.StartTime)).And(fmt.Sprintf("time <= '%s'", appRequest.EndTime))
		queryQB.Where(fmt.Sprintf("time >= '%s'", appRequest.StartTime)).And(fmt.Sprintf("time <= '%s'", appRequest.EndTime))
	}

	sql := fmt.Sprintf("%s SAMPLE BY 1d ALIGN TO CALENDAR", countQB.String())
	sql = fmt.Sprintf("SELECT count(*) FROM (%s);", sql)

	total, err := postgres.QueryTotal(sql)
	if err != nil {
		server.respond(models.BusinessFailed, err.Error())
		return
	}
	logs.Debug("total = %d", total)
	var responseTasks []models.Bills
	if total == 0 {
		responseData := struct {
			Total int64       `json:"total"`
			Data  interface{} `json:"data,omitempty"`
		}{
			Total: total,
			Data:  responseTasks,
		}
		server.respond(http.StatusOK, "", responseData)
		return
	}

	//queryQB.OrderBy("time").Desc()
	sql = fmt.Sprintf("%s SAMPLE BY 1d ALIGN TO CALENDAR ORDER BY time DESC LIMIT %d,%d;", queryQB.String(), offset, size)
	counts, err := postgres.QueryBills(sql)
	if err != nil {
		server.respond(models.BusinessFailed, err.Error())
		return
	}
	responseData := struct {
		Total int64       `json:"total"`
		Data  interface{} `json:"data,omitempty"`
	}{
		Total: total,
		Data:  counts,
	}
	server.respond(http.StatusOK, "", responseData)
}

func getWeiPerWorkload(dates []string) ([]models.WeiPerWorkloadStruct, error) {
	host, _ := beego.AppConfig.String("rewardUrl")
	url := host + "/api/v1/workload"
	payload := new(bytes.Buffer)
	json.NewEncoder(payload).Encode(dates)
	resp, err := http.Post(url, "application/json;charset=UTF-8", payload)
	if err != nil {
		logs.Info("Error sending request:", err)
		return nil, err
	}
	defer resp.Body.Close()
	logs.Info("getWeiPerWorkload resp code", resp.StatusCode)
	body, err := io.ReadAll(resp.Body)
	if err != nil {
		logs.Info("Error reading response:", err)
		return nil, err
	}
	var response models.WeiPerWorkloadResponse
	if err := json.Unmarshal(body, &response); err != nil {
		logs.Info("Error Unmarshal response:", err)
		return nil, err
	}
	return response.Data, nil
}

func contains(arr []string, target string) bool {
	for _, item := range arr {
		if item == target {
			return true
		}
	}
	return false
}

func weiToAGI(wei *big.Int) *big.Float {
	weiInAGI := new(big.Float).SetInt(big.NewInt(1000000000000000000)) // 10^18

	// 将 Wei 转换为 ETH，除以 10^18
	agi := new(big.Float).Quo(new(big.Float).SetInt(wei), weiInAGI)

	return agi
}

func (server *ClientController) TaskReward() {
	body := server.Ctx.Input.RequestBody
	appRequest := models.AppRequest{}
	err := json.Unmarshal(body, &appRequest) //解析body中数据
	logs.Debug("appRequest", appRequest, string(body))

	if appRequest.Page == 0 {
		appRequest.Page = 1
	}
	if appRequest.Size == 0 {
		appRequest.Size = 10
	}
	offset := (appRequest.Page - 1) * appRequest.Size
	size := appRequest.Page * appRequest.Size

	if appRequest.WorkerAcc == "" {
		server.respond(models.MissingParameter, "Missing worker_acc.")
		return
	}

	countQB, _ := orm.NewQueryBuilder("mysql")
	countQB.Select("count(*)").
		From("bills")

	queryQB, _ := orm.NewQueryBuilder("mysql")
	queryQB.Select("id", "type", "time", "workload", "profit_acc", "worker_acc").
		From("bills")

	if appRequest.WorkerAcc != "" {
		countQB.Where(fmt.Sprintf("worker_acc = '%s'", appRequest.WorkerAcc))
		queryQB.Where(fmt.Sprintf("worker_acc = '%s'", appRequest.WorkerAcc))
	}

	if appRequest.StartTime != "" && appRequest.EndTime != "" {
		temp, _ := time.Parse(layout, appRequest.StartTime)
		startTime := fmt.Sprintf(temp.Format(format))
		temp, _ = time.Parse(layout, appRequest.EndTime)
		endTime := fmt.Sprintf(temp.Format(format))
		countQB.And(fmt.Sprintf("time >= '%s'", startTime)).And(fmt.Sprintf("time <= '%s'", endTime))
		queryQB.And(fmt.Sprintf("time >= '%s'", startTime)).And(fmt.Sprintf("time <= '%s'", endTime))
	}

	sql := countQB.String()
	total, err := postgres.QueryTotal(sql)
	if err != nil {
		server.respond(models.BusinessFailed, err.Error())
		return
	}
	logs.Debug("total = %d", total)
	var responseTasks []*models.Revenues
	if total == 0 {
		responseData := struct {
			Total int64       `json:"total"`
			Data  interface{} `json:"data,omitempty"`
		}{
			Total: total,
			Data:  responseTasks,
		}
		server.respond(http.StatusOK, "", responseData)
		return
	}

	queryQB.OrderBy("time").Desc()
	sql = fmt.Sprintf("%s LIMIT %d,%d;", queryQB.String(), offset, size)
	data, err := postgres.QueryBills(sql)
	if err != nil {
		server.respond(models.BusinessFailed, err.Error())
		return
	}

	groupedItems := make(map[string][]*models.Revenues)

	// 遍历对象数组，按照日期进行分组
	var dates []string
	dateString := ""
	ids := ""
	for _, item := range data {
		// 将日期转换为当天的 0 点
		date := time.Date(item.Time.Year(), item.Time.Month(), item.Time.Day(), 0, 0, 0, 0, time.UTC)
		// 将 item 添加到对应日期的分组中
		key := date.Format(format)
		//key := date.Format("2006-01-02")
		if !contains(dates, key) {
			dates = append(dates, key)
			dateString = dateString + "'" + key + "'" + ","
		}

		baseModel := ""
		typeDe := 0
		taskId := item.Type

		ids = ids + "'" + strconv.Itoa(taskId) + "'" + ","
		reTask := &models.Revenues{
			Id:        item.Id,
			Type:      models.ModelType(typeDe).String(),
			Time:      item.Time,
			BaseModel: baseModel,
			Workload:  item.Workload,
			ProfitAcc: item.ProfitAcc,
			TaskId:    taskId,
		}
		responseTasks = append(responseTasks, reTask)
		groupedItems[key] = append(groupedItems[key], reTask)
	}
	if len(dates) > 0 {
		dateString = dateString[:len(dateString)-1]
	}
	if len(ids) > 2 {
		ids = ids[:len(ids)-1]
	}

	queryTaskQB, _ := orm.NewQueryBuilder("mysql")
	queryTaskQB.Select("task_type.id",
		"task_type.base_model",
		"task_type.type").
		From("task_type").Where(fmt.Sprintf("id in(%s)", ids))
	var types []*models.Model
	sql = queryTaskQB.String()
	mysql.GetMysqlInstace().Ormer.Raw(sql).QueryRows(&types)

	//wei, err := getWeiPerWorkload(dates)
	//wei := []models.WeiPerWorkloadStruct{
	//	{
	//		Date:           "2024-05-08",
	//		WeiPerWorkload: "1000000000000",
	//		Workload:       "1000",
	//		Reward:         "10000",
	//	},
	//}
	sql = fmt.Sprintf("SELECT * FROM reward_multiplier WHERE time in(%s) ORDER BY time DESC;", dateString)
	wei, err := postgres.QueryWei(sql)
	//return total, data, err
	for _, value := range wei {
		key := value.Time.Format(format)
		bills := groupedItems[key]
		for _, item := range bills {
			for _, task := range types {
				if task.Id == item.TaskId {
					item.Type = models.ModelType(task.Type).String()
					item.BaseModel = task.BaseModel
				}
			}
			workload := big.NewInt(item.Workload)
			weiPerWorkload, _ := strconv.Atoi(value.Wei)
			weiPerWorkloadBig := big.NewInt(int64(weiPerWorkload))
			incomeWei := new(big.Int).Mul(workload, weiPerWorkloadBig)
			income := weiToAGI(incomeWei)
			item.Income = income
		}
	}
	responseData := struct {
		Total int64       `json:"total"`
		Data  interface{} `json:"data,omitempty"`
	}{
		Total: total,
		Data:  responseTasks,
	}
	server.respond(http.StatusOK, "", responseData)
}

func (server *ClientController) AllNode() {
	data, err := registry.NodeManagers()
	if err != nil {
		server.respond(models.BusinessFailed, err.Error())
		return
	}
	//var nodes []registor.RegistryInfo
	//for _, value := range data {
	//	var node registor.RegistryInfo
	//	if err := json.Unmarshal([]byte(value), &node); err == nil {
	//		server.respond(models.BusinessFailed, err.Error())
	//		return
	//	}
	//	nodes = append(nodes, node)
	//}

	server.respond(http.StatusOK, "", data)
}

func (server *ClientController) AddressByIP() {
	body := server.Ctx.Input.RequestBody
	appRequest := models.AppRequest{}
	_ = json.Unmarshal(body, &appRequest) //解析body中数据
	logs.Debug("appRequest", appRequest, string(body))
	if appRequest.Ips == nil || (appRequest.Ips != nil && len(appRequest.Ips) <= 0) {
		server.respond(models.MissingParameter, "Missing ips parameter")
		return
	}

	address := make(map[string]interface{})
	for _, value := range appRequest.Ips {
		temp := ipgeo.GetIpAddr(value)
		logs.Debug("AddressByIP", temp)
		address[value] = temp
	}
	//data, err := json.Marshal(address)
	//if err != nil {
	//	server.respond(models.BusinessFailed, err.Error())
	//	return
	//}
	server.respond(http.StatusOK, "", address)
}

func (server *ClientController) IncomeRecord() {

	body := server.Ctx.Input.RequestBody
	appRequest := models.AppRequest{}
	err := json.Unmarshal(body, &appRequest) //解析body中数据
	logs.Debug("appRequest", appRequest)

	if appRequest.Page == 0 {
		appRequest.Page = 1
	}
	if appRequest.Size == 0 {
		appRequest.Size = 10
	}
	offset := (appRequest.Page - 1) * appRequest.Size
	size := appRequest.Page * appRequest.Size

	if appRequest.ProfitAcc == "" {
		server.respond(models.MissingParameter, "Missing profit_acc.")
		return
	}

	countQB, _ := orm.NewQueryBuilder("mysql")
	countQB.Select("count(*)").
		From("bills")

	queryQB, _ := orm.NewQueryBuilder("mysql")
	queryQB.Select("sum(workload) AS workload", "time").
		From("bills")

	if appRequest.ProfitAcc != "" {
		countQB.Where(fmt.Sprintf("profit_acc = '%s'", appRequest.ProfitAcc))
		queryQB.Where(fmt.Sprintf("profit_acc = '%s'", appRequest.ProfitAcc))
	}

	sql := fmt.Sprintf("%s SAMPLE BY 1d ALIGN TO CALENDAR", countQB.String())
	sql = fmt.Sprintf("SELECT count(*) FROM (%s);", sql)

	//sql := countQB.String()
	total, err := postgres.QueryTotal(sql)
	if err != nil {
		server.respond(models.BusinessFailed, err.Error())
		return
	}
	logs.Debug("total = %d", total)
	var responseTasks []*models.Revenues
	if total == 0 {
		responseData := struct {
			Total int64       `json:"total"`
			Data  interface{} `json:"data,omitempty"`
		}{
			Total: total,
			Data:  responseTasks,
		}
		server.respond(http.StatusOK, "", responseData)
		return
	}

	//queryQB.OrderBy("time").Desc()
	sql = fmt.Sprintf("%s SAMPLE BY 1d ALIGN TO CALENDAR ORDER BY time DESC LIMIT %d,%d;", queryQB.String(), offset, size)
	//sql = fmt.Sprintf("%s LIMIT %d,%d;", queryQB.String(), offset, size)
	revenues, err := postgres.QueryBills(sql)
	if err != nil {
		server.respond(models.BusinessFailed, err.Error())
		return
	}
	groupedItems := make(map[string][]*models.Revenues)

	// 遍历对象数组，按照日期进行分组
	var dates []string
	dateString := ""
	for _, item := range revenues {
		// 将日期转换为当天的 0 点
		date := time.Date(item.Time.Year(), item.Time.Month(), item.Time.Day(), 0, 0, 0, 0, time.UTC)
		// 将 item 添加到对应日期的分组中
		//key := date.Format("2006-01-02")
		key := date.Format(format)
		if !contains(dates, key) {
			dates = append(dates, key)
			dateString = dateString + "'" + key + "'" + ","
		}

		reTask := &models.Revenues{
			Id:       item.Id,
			Type:     "Work income",
			Time:     item.Time,
			Workload: item.Workload,
		}
		responseTasks = append(responseTasks, reTask)
		groupedItems[key] = append(groupedItems[key], reTask)
	}
	if len(dates) > 0 {
		dateString = dateString[:len(dateString)-1]
	}

	//wei, err := getWeiPerWorkload(dates)
	//wei := []models.WeiPerWorkloadStruct{
	//	{
	//		Date:           "2024-05-08",
	//		WeiPerWorkload: "1000000000000",
	//		Workload:       "1000",
	//		Reward:         "10000",
	//	},
	//}
	sql = fmt.Sprintf("SELECT * FROM reward_multiplier WHERE time in(%s) ORDER BY time DESC;", dateString)
	wei, err := postgres.QueryWei(sql)
	for _, value := range wei {
		key := value.Time.Format(format)
		bills := groupedItems[key]
		for _, item := range bills {
			workload := big.NewInt(item.Workload)
			weiPerWorkload, _ := strconv.Atoi(value.Wei)
			weiPerWorkloadBig := big.NewInt(int64(weiPerWorkload))
			incomeWei := new(big.Int).Mul(workload, weiPerWorkloadBig)
			income := weiToAGI(incomeWei)
			item.Income = income
		}
	}
	responseData := struct {
		Total int64       `json:"total"`
		Data  interface{} `json:"data,omitempty"`
	}{
		Total: total,
		Data:  responseTasks,
	}
	server.respond(http.StatusOK, "", responseData)
}

func (server *ClientController) TotalReward() {
	requestBody := server.Ctx.Input.RequestBody
	appRequest := models.AppRequest{}
	err := json.Unmarshal(requestBody, &appRequest) //解析body中数据
	logs.Debug("appRequest", appRequest)

	if appRequest.ProfitAcc == "" {
		server.respond(models.MissingParameter, "Missing profit_acc.")
		return
	}

	host, _ := beego.AppConfig.String("rewardUrl")
	url := host + "/api/v1/reward"
	requestJaon := models.TotalRevenuesRequest{
		Address: appRequest.ProfitAcc,
	}
	payload := new(bytes.Buffer)
	json.NewEncoder(payload).Encode(requestJaon)
	resp, err := http.Post(url, "application/json;charset=UTF-8", payload)
	if err != nil {
		logs.Info("Error sending request:", err)
		server.respond(models.BusinessFailed, err.Error())
		return
	}
	defer resp.Body.Close()
	logs.Info("TotalReward resp code", resp.StatusCode)
	body, err := io.ReadAll(resp.Body)
	if err != nil {
		logs.Info("Error reading response:", err)
		server.respond(models.BusinessFailed, err.Error())
		return
	}
	var response models.TotalRevenuesResponse
	if err := json.Unmarshal(body, &response); err != nil {
		server.respond(models.BusinessFailed, err.Error())
		return
	}
	server.respond(http.StatusOK, "", response.Data)
}

func (server *ClientController) WithdrawalRecord() {
	requestBody := server.Ctx.Input.RequestBody
	appRequest := models.AppRequest{}
	err := json.Unmarshal(requestBody, &appRequest) //解析body中数据
	logs.Debug("appRequest", appRequest)

	if appRequest.Page == 0 {
		appRequest.Page = 1
	}
	if appRequest.Size == 0 {
		appRequest.Size = 10
	}

	if appRequest.ProfitAcc == "" {
		server.respond(models.MissingParameter, "Missing profit_acc.")
		return
	}

	host, _ := beego.AppConfig.String("rewardUrl")
	url := host + "/api/v1/record"
	payload := new(bytes.Buffer)
	requestJson := models.WithdrawalRecordRequest{
		Address:  appRequest.ProfitAcc,
		Page:     int(appRequest.Page),
		PageSize: int(appRequest.Size),
	}
	json.NewEncoder(payload).Encode(requestJson)
	resp, err := http.Post(url, "application/json;charset=UTF-8", payload)
	if err != nil {
		logs.Info("Error sending request:", err)
		server.respond(models.BusinessFailed, err.Error())
		return
	}
	defer resp.Body.Close()
	logs.Info("getWeiPerWorkload resp code", resp.StatusCode)
	body, err := io.ReadAll(resp.Body)
	if err != nil {
		logs.Info("Error reading response:", err)
		server.respond(models.BusinessFailed, err.Error())
		return
	}
	var response models.WithdrawalRecordResponse
	if err := json.Unmarshal(body, &response); err != nil {
		server.respond(models.BusinessFailed, err.Error())
		return
	}
	server.respond(http.StatusOK, "", response.Data)
}
