package models

type CreateUserRequest struct {
	Username string `json:"username"`
	CustomId string `json:"custom_id"`
}

type CreateUserResponse struct {
	Id        string      `json:"id"`
	CreatedAt int         `json:"created_at"`
	Username  string      `json:"username"`
	Tags      interface{} `json:"tags"`
	CustomId  string      `json:"custom_id"`
	UpdatedAt int         `json:"updated_at"`
	Fields    struct {
		Username string `json:"username"`
	} `json:"fields"`
	Code    int    `json:"code"`
	Message string `json:"message"`
	Name    string `json:"name"`
}

type CreateApiKeyResponse struct {
	Key       string      `json:"key"`
	CreatedAt int         `json:"created_at"`
	Ttl       interface{} `json:"ttl"`
	Tags      interface{} `json:"tags"`
	Consumer  struct {
		Id string `json:"id"`
	} `json:"consumer"`
	Id      string `json:"id"`
	Code    int    `json:"code,omitempty"`
	Message string `json:"message,omitempty"`
}

type APIKeys struct {
	Next interface{}            `json:"next"`
	Data []CreateApiKeyResponse `json:"data"`
}

type JWTResponse struct {
	Algorithm string `json:"algorithm"`
	Consumer  struct {
		Id string `json:"id"`
	} `json:"consumer"`
	CreatedAt    int         `json:"created_at"`
	Id           string      `json:"id"`
	Key          string      `json:"key"`
	RsaPublicKey interface{} `json:"rsa_public_key"`
	Secret       string      `json:"secret"`
	Tags         interface{} `json:"tags"`
	Code         int         `json:"code,omitempty"`
	Message      string      `json:"message,omitempty"`
}

type JWTS struct {
	Next interface{}   `json:"next"`
	Data []JWTResponse `json:"data"`
}

type Plugin struct {
	Id           string      `json:"id"`
	Name         string      `json:"name"`
	CreatedAt    int         `json:"created_at"`
	UpdatedAt    int         `json:"updated_at"`
	Route        interface{} `json:"route"`
	Service      interface{} `json:"service"`
	Consumer     interface{} `json:"consumer"`
	InstanceName interface{} `json:"instance_name"`
	Config       struct {
		Hour   int `json:"hour"`
		Minute int `json:"minute"`
	} `json:"config"`
	Protocols []string `json:"protocols"`
	Enabled   bool     `json:"enabled"`
	Tags      []string `json:"tags"`
	Ordering  struct {
		Before []string `json:"before"`
	} `json:"ordering"`
	Code    int    `json:"code,omitempty"`
	Message string `json:"message,omitempty"`
}

type Plugins struct {
	Next interface{} `json:"next"`
	Data []Plugin    `json:"data"`
}
