package controllers

import (
	"aon_app_server/models"
	"aon_app_server/utils/mongo"
	"encoding/json"
	"github.com/beego/beego/v2/core/logs"
	"go.mongodb.org/mongo-driver/bson"
	"net/http"
	"time"
)

type TemplateController struct {
	MainController
}

func (server *TemplateController) Add() {
	body := server.Ctx.Input.RequestBody
	template := models.Template{}
	err := json.Unmarshal(body, &template) //解析body中数据
	logs.Debug("appRequest", template)
	if err != nil {
		server.respond(models.NoRequestBody, err.Error())
		return
	}

	template.CreatedTime = time.Now().UTC()
	template.UpdatedTime = template.CreatedTime
	_, err = mongo.Insert(&template)
	if err != nil {
		server.respond(models.BusinessFailed, err.Error())
		return
	}
	server.respond(http.StatusOK, "")
}

func (server *TemplateController) Update() {
	body := server.Ctx.Input.RequestBody
	template := models.Template{}
	err := json.Unmarshal(body, &template) //解析body中数据
	logs.Debug("appRequest", template)
	if err != nil {
		server.respond(models.NoRequestBody, err.Error())
		return
	}

	if template.Id == nil {
		server.respond(models.MissingParameter, "id param is null")
		return
	}
	template.UpdatedTime = time.Now().UTC()
	_, err = mongo.Update(template)
	if err != nil {
		server.respond(models.BusinessFailed, err.Error())
		return
	}
	server.respond(http.StatusOK, "")
}

func (server *TemplateController) Delete() {
	body := server.Ctx.Input.RequestBody
	template := models.Template{}
	err := json.Unmarshal(body, &template) //解析body中数据
	logs.Debug("appRequest", template)
	if err != nil {
		server.respond(models.NoRequestBody, err.Error())
		return
	}

	if template.Id == nil {
		server.respond(models.MissingParameter, "id param is null")
		return
	}

	template.UpdatedTime = time.Now().UTC()

	template.Deleted = 1
	_, err = mongo.Update(template)
	if err != nil {
		server.respond(models.BusinessFailed, err.Error())
		return
	}
	server.respond(http.StatusOK, "")
}

func (server *TemplateController) List() {
	body := server.Ctx.Input.RequestBody
	request := models.ListRequest{}
	err := json.Unmarshal(body, &request) //解析body中数据
	logs.Debug("appRequest", request)
	if err != nil {
		server.respond(models.NoRequestBody, err.Error())
		return
	}

	if request.Page == 0 {
		request.Page = 1
	}
	if request.Size == 0 {
		request.Size = 10
	}

	total, data, err := mongo.Query("Template", request.Page, request.Size, request.Filter)
	if err != nil {
		logs.Info("List Error:", err)
		server.respond(models.BusinessFailed, err.Error())
	}

	var templates []models.Template
	for _, bsonD := range data {
		var template models.Template
		// 将 bson.D 转换为 bson.Raw
		bsonRaw, err := bson.Marshal(bsonD)
		if err != nil {
			server.respond(models.BusinessFailed, err.Error())
		}
		// 将 bson.Raw 解码为 User 结构体
		err = bson.Unmarshal(bsonRaw, &template)
		if err != nil {
			server.respond(models.BusinessFailed, err.Error())
		}
		templates = append(templates, template)
	}
	responseData := struct {
		Total int64       `json:"total"`
		Data  interface{} `json:"data,omitempty"`
	}{
		Total: total,
		Data:  templates,
	}
	server.respond(http.StatusOK, "", responseData)

}
