package models

import "time"

type Log struct {
	Id        interface{} `json:"id" bson:"_id,omitempty"`
	Version   string      `json:"sdk_version,omitempty" bson:"sdk_version"`
	Time      time.Time   `json:"time" bson:"time"`
	UserId    string      `json:"user_id" bson:"user_id"`
	Device    string      `json:"device" bson:"device"`
	Platform  string      `json:"platform" bson:"platform"`
	Error     string      `json:"error" bson:"error"`
	Method    string      `json:"method" bson:"method"`
	Input     interface{} `json:"input" bson:"input"`
	UserAgent string      `json:"user_agent" bson:"user_agent"`
	IsMobile  string      `json:"is_mobile" bson:"is_mobile"`
	SecUa     string      `json:"sec_ua" bson:"sec_ua"`
}
