package models

import "time"

//type Position int
//
//const (
//	TOPLEFT Position = iota + 1
//	TOPRIGHT
//	TOPMIDDLE
//	LEFTMIDDLE
//	LEFTBOTTOM
//	BOTTOMMIDDLE
//	RIGHTBOTTOM
//	RIGHTMIDDLE
//	CENTER
//)

type Position struct {
	X int `json:"x,omitempty" bson:"x"`
	Y int `json:"y,omitempty" bson:"y"`
}

//type Params struct {
//	Ai struct {
//		StableDiffusion3 []struct {
//			Field string      `json:"field"`
//			Name  string      `json:"name"`
//			Type  interface{} `json:"type"`
//		} `json:"stable-diffusion-3"`
//	} `json:"ai"`
//	Ui []struct {
//		Field      string      `json:"field"`
//		Name       string      `json:"name"`
//		Type       interface{} `json:"type"`
//		Enum       []string    `json:"enum,omitempty"`
//		Properties []struct {
//			Field  string      `json:"field"`
//			Name   string      `json:"name"`
//			Type   interface{} `json:"type"`
//			Format string      `json:"format,omitempty"`
//			IsShow bool        `json:"is_show,omitempty"`
//		} `json:"properties,omitempty"`
//	} `json:"ui"`
//}

//type Params struct {
//	Ui []struct {
//		Field  string      `json:"field"`
//		Name   string      `json:"name"`
//		Type   interface{} `json:"type"`
//		Format string      `json:"format,omitempty"`
//		IsShow bool        `json:"is_show,omitempty"`
//	} `json:"ui"`
//}

type Template struct {
	Id          interface{} `json:"id" bson:"_id,omitempty"`
	Name        string      `json:"name,omitempty" bson:"name"`
	Desc        string      `json:"desc,omitempty" bson:"desc"`
	Params      interface{} `json:"params,omitempty" bson:"params"`
	UserId      string      `json:"user_id,omitempty" bson:"user_id"`
	CreatedTime time.Time   `json:"created_time" bson:"created_time"`
	UpdatedTime time.Time   `json:"updated_time" bson:"updated_time"`
	Deleted     int         `json:"deleted" bson:"deleted"`
}

type TemplateData struct {
	Id             interface{} `json:"id" bson:"_id,omitempty"`
	TemplateId     interface{} `json:"template_id" bson:"template_id"`
	TemplateParams interface{} `json:"template_params" bson:"template_params"`
	ParamsValue    interface{} `json:"params_value" bson:"params_value"`
	UserId         string      `json:"user_id,omitempty" bson:"user_id"`
	CreatedTime    time.Time   `json:"created_time" bson:"created_time"`
	UpdatedTime    time.Time   `json:"updated_time" bson:"updated_time"`
	Deleted        int         `json:"deleted" bson:"deleted"`
}

//type TemplateData struct {
//	Id                interface{} `json:"id" bson:"_id,omitempty"`
//	TemplateId        interface{} `json:"template_id" bson:"template_id"`
//	Logo              string      `json:"logo,omitempty" bson:"logo"`                             // 海报图片上展示的logo，非 应用logo
//	Image             string      `json:"image,omitempty" bson:"image"`                           //模版展示的图片
//	ProjectName       string      `json:"project_name,omitempty" bson:"project_name"`             // 海报图片上展示的文字，非 应用标题
//	Place             string      `json:"place,omitempty" bson:"place"`                           // 地点名称
//	Watermark         string      `json:"watermark,omitempty" bson:"watermark"`                   //商家 的 水印
//	WatermarkPosition Position    `json:"watermark_position,omitempty" bson:"watermark_position"` //商家 的 水印位置
//	Platform          string      `json:"platform,omitempty" bson:"platform"`                     //平台 的 水印
//	PlatformPosition  Position    `json:"platform_position,omitempty" bson:"platform_position"`
//	Prompt            string      `json:"prompt,omitempty" bson:"prompt"`
//	Audio             string      `json:"audio,omitempty" bson:"audio"`
//	Type              int         `json:"type,omitempty" bson:"type"` // 1 poster,2 speaker,3 meme
//	CreatedTime       time.Time   `json:"created_time" bson:"created_time"`
//	UpdatedTime       time.Time   `json:"updated_time" bson:"updated_time"`
//	Deleted           int         `json:"deleted" bson:"deleted"`
//}

//type Template struct {
//	Id                interface{} `json:"id" bson:"_id,omitempty"`
//	Image             string      `json:"image,omitempty" bson:"image"`                           //模版展示的图片
//	Watermark         string      `json:"watermark,omitempty" bson:"watermark"`                   //商家 的 水印
//	WatermarkPosition Position    `json:"watermark_position,omitempty" bson:"watermark_position"` //商家 的 水印位置
//	Platform          string      `json:"platform,omitempty" bson:"platform"`                     //平台 的 水印
//	PlatformPosition  Position    `json:"platform_position,omitempty" bson:"platform_position"`
//	Prompt            string      `json:"prompt,omitempty" bson:"prompt"`
//	CreatedTime       time.Time   `json:"created_time" bson:"created_time"`
//	UpdatedTime       time.Time   `json:"updated_time" bson:"updated_time"`
//	Deleted           int         `json:"deleted" bson:"deleted"`
//}
//
//type PosterTemplate struct {
//	Template
//	Audio string `json:"audio,omitempty" bson:"audio"`
//}
//
//type SpeakerTemplate struct {
//	Template
//	ProjectName string `json:"project_name,omitempty" bson:"project_name"` // 海报图片上展示的文字，非 应用标题
//	Logo        string `json:"logo,omitempty" bson:"logo"`                 // 海报图片上展示的logo，非 应用logo
//	Place       string `json:"place,omitempty" bson:"place"`               // 地点名称
//}
