package models

import "time"

const (
	NoRequestBody = iota + 5000
	MissingParameter
	CreateUserFailed
	LoginFailed
	BusinessFailed
	Web3VerifyFailed
	Web3LoginTimeout
	Web3ClinetIdError
)

type Task struct {
	Id              interface{} `json:"id" bson:"_id,omitempty"`
	TaskId          string      `json:"task_id,omitempty" bson:"task_id"`
	Input           interface{} `json:"input" bson:"input"`
	ApiPath         string      `json:"api_path" bson:"api_path"`
	UserId          string      `json:"user_id" bson:"user_id"`
	Status          int         `json:"status" bson:"status"`
	Output          interface{} `json:"output" bson:"output"`
	ReplicateOutput interface{} `json:"replicate_output" bson:"replicate_output"`
	Error           interface{} `json:"error" bson:"error"`
	ExcuteId        string      `json:"excute_id" bson:"excute_id"`
	AppId           string      `json:"app_id" bson:"app_id"`
	CreatedTime     time.Time   `json:"created_time" bson:"created_time"`
	UpdatedTime     time.Time   `json:"updated_time" bson:"updated_time"`
	Deleted         int         `json:"deleted" bson:"deleted"`
}

type ReplicateRequest struct {
	Version string      `json:"version,omitempty"`
	Input   interface{} `json:"input"`
	Stream  bool        `json:"stream,omitempty"`
}

type ReplicateResponse struct {
	Id          string      `json:"id"`
	Model       string      `json:"model"`
	Version     string      `json:"version"`
	Input       interface{} `json:"input"`
	Logs        string      `json:"logs"`
	Output      interface{} `json:"output"`
	DataRemoved bool        `json:"data_removed"`
	Error       interface{} `json:"error"`
	Status      string      `json:"status"`
	CreatedAt   time.Time   `json:"created_at"`
	Urls        struct {
		Cancel string `json:"cancel"`
		Get    string `json:"get"`
		Stream string `json:"stream"`
	} `json:"urls"`
}

type TaskReturn struct {
	TaskId    string `json:"task_id"`
	TaskUid   string `json:"task_uid"`
	TaskFee   string `json:"task_fee"`
	IsSuccess bool   `json:"is_success"`
	TaskError string `json:"task_error"`
	ExecCode  int    `json:"exec_code"`
	ExecError string `json:"exec_error"`
	Async     bool   `json:"async"`
	ApiError  struct {
		RequestId string `json:"request_id"`
		Message   string `json:"message"`
	} `json:"api_error"`
}

type TaskResponse struct {
	Task   *TaskReturn `json:"task"`
	Output interface{} `json:"output"`
}

type TaskResponseNew struct {
	Output interface{} `json:"output,omitempty"`
	Error  interface{} `json:"error,omitempty"`
}

type TaskResult struct {
	Id           int       `json:"id";orm:"column(id);auto"`
	TaskId       string    `json:"task_id,omitempty";orm:"column(task_id)"`
	Fee          int64     `json:"fee";orm:"column(fee)"`
	OutLen       int       `json:"out_len";orm:"column(out_len)"`
	workload     int       `json:"workload";orm:"column(workload)"`
	TaskDuration int       `json:"task_duration";orm:"column(task_duration)"`
	ExecDuration int       `json:"exec_duration";orm:"column(exec_duration)"`
	Result       string    `json:"result";orm:"column(result)"`
	Output       string    `json:"output";orm:"column(output)"`
	Error        string    `json:"error";orm:"column(error);type(json)"`
	CreatedTime  time.Time `json:"created_time";orm:"column(created_time);auto_now_add;type(datetime)"`
	UpdatedTime  time.Time `json:"updated_time";orm:"column(updated_time);auto_now;type(datetime)"`
	Deleted      int       `json:"deleted";orm:"column(deleted);size(1)"`
}

type ListRequest struct {
	Page   int         `json:"page"`
	Size   int         `json:"size"`
	Filter interface{} `json:"filter"`
}

type ImageCopied struct {
	Code int    `json:"code"`
	Msg  string `json:"msg"`
	Data string `json:"data"`
}
type ImagesToCopy struct {
	Sources []string `json:"sources"`
}
