
## 测试命令


./k6 run --vus 1000   --duration 30s http.js 


## 测试记录


| 序号 |  k6    | kong  | 插件                 |   k6 速率             | 资源占用      |
|:--: | :---: | :----: | :----:               |  :----:              |:----:         |  
|1    |  220   |   220 | -Request Termination |  117307.64096/s      |220 cpu 70%   |
|2    |  220   |   220 | +Correlation ID      |  117977.894485/s     |220 cpu 70%   |
|3    |  220   |   220 | ++Key Authentication |  108248.021066/s     |220 cpu 70%   |
|4    |  220   |   10  | -Request Termination |  63917.814742/s      |10  20% <  cpu < 30%   |
|5    |  220   |   10  | +Correlation ID      |  63913.937413/s      |10  20% <  cpu < 30%   |
|6    |  220   |   10  | ++Key Authentication |  58575.378431/s      |10  25% <  cpu < 30%   |



| 序号  |  k6    | kong   | api-backend | stage        |   k6 速率         | 资源占用      |
|:--:  | :---:  | :----: |  :----:     | :----:       | :----:           |:----:        |  
|1    |  220    |   220   |   10        | echo        |  79404.849277/s | 10  < 10%   |
|2    |  220    |   220   |   10        | befor query fmt |  43105.021988/s | 10  < 10%   |
|3    |  220    |   220   |   10        | befor query |  75748.172807/s | 10   12%   |
|4    |  220    |   220   |   10        | *after query* |  2012.898742/s | 10  < 10%   |
|5    |  220    |   220   |   10        | kafka async |  70213.176116/s | 10  < 10%   |
|6    |  220    |   220   |   10        | kafka sync  |  60363.220981/s | 10  < 10%   |









### 单机测试

* kong 环境： 在gateway service上启用 Request Termination插件； 
* kong 结果： 收发在220服务器上    cpu  70%

```console
wuban@node-220:/data/benchmark/http$ ./k6 run --vus 100   --duration 30s http.js 

          /\      |‾‾| /‾‾/   /‾‾/   
     /\  /  \     |  |/  /   /  /    
    /  \/    \    |     (   /   ‾‾\  
   /          \   |  |\  \ |  (‾)  | 
  / __________ \  |__| \__\ \_____/ .io

  execution: local
     script: http.js
     output: -

  scenarios: (100.00%) 1 scenario, 100 max VUs, 1m0s max duration (incl. graceful stop):
           * default: 100 looping VUs for 30s (gracefulStop: 30s)


     ✓ status is 200

     checks.........................: 100.00% ✓ 3519558      ✗ 0      
     data_received..................: 704 MB  24 MB/s
     data_sent......................: 1.1 GB  38 MB/s
     http_req_blocked...............: avg=3.1µs    min=1.14µs   med=1.86µs   max=29.27ms p(90)=2.94µs  p(95)=3.73µs 
     http_req_connecting............: avg=252ns    min=0s       med=0s       max=14.75ms p(90)=0s      p(95)=0s     
     http_req_duration..............: avg=652.07µs min=87.93µs  med=353.27µs max=35.36ms p(90)=1.53ms  p(95)=2.37ms 
       { expected_response:true }...: avg=652.07µs min=87.93µs  med=353.27µs max=35.36ms p(90)=1.53ms  p(95)=2.37ms 
     http_req_failed................: 0.00%   ✓ 0            ✗ 3519558
     http_req_receiving.............: avg=26.5µs   min=7.62µs   med=17.19µs  max=34.09ms p(90)=24.21µs p(95)=28.42µs
     http_req_sending...............: avg=15.8µs   min=7.3µs    med=11.41µs  max=29.15ms p(90)=18.04µs p(95)=20.7µs 
     http_req_tls_handshaking.......: avg=0s       min=0s       med=0s       max=0s      p(90)=0s      p(95)=0s     
     http_req_waiting...............: avg=609.76µs min=63.66µs  med=321.06µs max=33.24ms p(90)=1.46ms  p(95)=2.3ms  
     http_reqs......................: 3519558 117307.64096/s
     iteration_duration.............: avg=827.08µs min=162.74µs med=469.41µs max=39.44ms p(90)=1.84ms  p(95)=2.73ms 
     iterations.....................: 3519558 117307.64096/s
     vus............................: 100     min=100        max=100  
     vus_max........................: 100     min=100        max=100  


running (0m30.0s), 000/100 VUs, 3519558 complete and 0 interrupted iterations
default ✓ [======================================] 100 VUs  30s
```



* kong 环境： 在gateway service上启用 Request Termination、Correlation ID插件； 
* kong 结果： 收发在220服务器上    cpu  70%

```console

wuban@node-220:/data/benchmark/http$ ./k6 run --vus 100   --duration 30s http.js 

          /\      |‾‾| /‾‾/   /‾‾/   
     /\  /  \     |  |/  /   /  /    
    /  \/    \    |     (   /   ‾‾\  
   /          \   |  |\  \ |  (‾)  | 
  / __________ \  |__| \__\ \_____/ .io

  execution: local
     script: http.js
     output: -

  scenarios: (100.00%) 1 scenario, 100 max VUs, 1m0s max duration (incl. graceful stop):
           * default: 100 looping VUs for 30s (gracefulStop: 30s)


     ✓ status is 200

     checks.........................: 100.00% ✓ 3539450       ✗ 0      
     data_received..................: 708 MB  24 MB/s
     data_sent......................: 1.1 GB  38 MB/s
     http_req_blocked...............: avg=3.3µs    min=1.01µs   med=1.86µs   max=30.96ms p(90)=2.95µs  p(95)=3.76µs 
     http_req_connecting............: avg=225ns    min=0s       med=0s       max=5.33ms  p(90)=0s      p(95)=0s     
     http_req_duration..............: avg=645.23µs min=88.51µs  med=351.18µs max=56.6ms  p(90)=1.45ms  p(95)=2.35ms 
       { expected_response:true }...: avg=645.23µs min=88.51µs  med=351.18µs max=56.6ms  p(90)=1.45ms  p(95)=2.35ms 
     http_req_failed................: 0.00%   ✓ 0             ✗ 3539450
     http_req_receiving.............: avg=27.35µs  min=7.25µs   med=17.31µs  max=53.42ms p(90)=24.31µs p(95)=28.56µs
     http_req_sending...............: avg=16.03µs  min=7.35µs   med=11.39µs  max=52.61ms p(90)=18.16µs p(95)=20.72µs
     http_req_tls_handshaking.......: avg=0s       min=0s       med=0s       max=0s      p(90)=0s      p(95)=0s     
     http_req_waiting...............: avg=601.85µs min=66.2µs   med=318.87µs max=42.9ms  p(90)=1.39ms  p(95)=2.25ms 
     http_reqs......................: 3539450 117977.894485/s
     iteration_duration.............: avg=822.49µs min=164.35µs med=463.58µs max=59.72ms p(90)=1.77ms  p(95)=2.8ms  
     iterations.....................: 3539450 117977.894485/s
     vus............................: 100     min=100         max=100  
     vus_max........................: 100     min=100         max=100  


running (0m30.0s), 000/100 VUs, 3539450 complete and 0 interrupted iterations
default ✓ [======================================] 100 VUs  30s

```


* kong 环境： 在gateway service上启用 Request Termination、Correlation ID、Key Authentication插件； 
* kong 结果： 收发在220服务器上    cpu  70%

```console


wuban@node-220:/data/benchmark/http$ ./k6 run --vus 100   --duration 30s http.js 

          /\      |‾‾| /‾‾/   /‾‾/   
     /\  /  \     |  |/  /   /  /    
    /  \/    \    |     (   /   ‾‾\  
   /          \   |  |\  \ |  (‾)  | 
  / __________ \  |__| \__\ \_____/ .io

  execution: local
     script: http.js
     output: -

  scenarios: (100.00%) 1 scenario, 100 max VUs, 1m0s max duration (incl. graceful stop):
           * default: 100 looping VUs for 30s (gracefulStop: 30s)


     ✓ status is 200

     checks.........................: 100.00% ✓ 3247922       ✗ 0      
     data_received..................: 650 MB  22 MB/s
     data_sent......................: 1.1 GB  35 MB/s
     http_req_blocked...............: avg=3.45µs   min=990ns    med=1.87µs   max=30.6ms  p(90)=3µs     p(95)=3.88µs 
     http_req_connecting............: avg=249ns    min=0s       med=0s       max=17.48ms p(90)=0s      p(95)=0s     
     http_req_duration..............: avg=731.03µs min=106.15µs med=393.42µs max=32.22ms p(90)=1.65ms  p(95)=2.66ms 
       { expected_response:true }...: avg=731.03µs min=106.15µs med=393.42µs max=32.22ms p(90)=1.65ms  p(95)=2.66ms 
     http_req_failed................: 0.00%   ✓ 0             ✗ 3247922
     http_req_receiving.............: avg=28.72µs  min=7.98µs   med=17.42µs  max=31.3ms  p(90)=25.16µs p(95)=29.24µs
     http_req_sending...............: avg=16.57µs  min=6.7µs    med=11.5µs   max=31.02ms p(90)=18.54µs p(95)=20.97µs
     http_req_tls_handshaking.......: avg=0s       min=0s       med=0s       max=0s      p(90)=0s      p(95)=0s     
     http_req_waiting...............: avg=685.73µs min=80.16µs  med=359.89µs max=30.12ms p(90)=1.58ms  p(95)=2.55ms 
     http_reqs......................: 3247922 108248.021066/s
     iteration_duration.............: avg=902.34µs min=179.85µs med=506.43µs max=37.74ms p(90)=1.93ms  p(95)=3.12ms 
     iterations.....................: 3247922 108248.021066/s
     vus............................: 100     min=100         max=100  
     vus_max........................: 100     min=100         max=100  


running (0m30.0s), 000/100 VUs, 3247922 complete and 0 interrupted iterations
default ✓ [======================================] 100 VUs  30s

```







### 跨机器测试

* kong 环境： 在gateway service上启用 Request Termination插件； 
* kong 结果： 10服务器  20% <  cpu < 30%

```console
wuban@node-220:/data/benchmark/http$ ./k6 run --vus 100   --duration 30s http.js 

          /\      |‾‾| /‾‾/   /‾‾/   
     /\  /  \     |  |/  /   /  /    
    /  \/    \    |     (   /   ‾‾\  
   /          \   |  |\  \ |  (‾)  | 
  / __________ \  |__| \__\ \_____/ .io

  execution: local
     script: http.js
     output: -

  scenarios: (100.00%) 1 scenario, 100 max VUs, 1m0s max duration (incl. graceful stop):
           * default: 100 looping VUs for 30s (gracefulStop: 30s)


     ✓ status is 200

     checks.........................: 100.00% ✓ 1917634      ✗ 0      
     data_received..................: 3.4 GB  112 MB/s
     data_sent......................: 619 MB  21 MB/s
     http_req_blocked...............: avg=3.75µs  min=1.07µs   med=2.08µs  max=13.27ms p(90)=3.24µs   p(95)=4.21µs 
     http_req_connecting............: avg=943ns   min=0s       med=0s      max=7.23ms  p(90)=0s       p(95)=0s     
     http_req_duration..............: avg=1.43ms  min=333.14µs med=1.23ms  max=31.19ms p(90)=2.25ms   p(95)=2.71ms 
       { expected_response:true }...: avg=1.43ms  min=333.14µs med=1.23ms  max=31.19ms p(90)=2.25ms   p(95)=2.71ms 
     http_req_failed................: 0.00%   ✓ 0            ✗ 1917634
     http_req_receiving.............: avg=87.12µs min=13.69µs  med=68.63µs max=20.8ms  p(90)=141.17µs p(95)=156.4µs
     http_req_sending...............: avg=17.92µs min=6.84µs   med=12.44µs max=4.67ms  p(90)=21.42µs  p(95)=27.43µs
     http_req_tls_handshaking.......: avg=0s      min=0s       med=0s      max=0s      p(90)=0s       p(95)=0s     
     http_req_waiting...............: avg=1.32ms  min=284.55µs med=1.13ms  max=31.07ms p(90)=2.14ms   p(95)=2.53ms 
     http_reqs......................: 1917634 63917.814742/s
     iteration_duration.............: avg=1.55ms  min=432.02µs med=1.34ms  max=31.31ms p(90)=2.36ms   p(95)=2.91ms 
     iterations.....................: 1917634 63917.814742/s
     vus............................: 100     min=100        max=100  
     vus_max........................: 100     min=100        max=100  


running (0m30.0s), 000/100 VUs, 1917634 complete and 0 interrupted iterations
default ✓ [======================================] 100 VUs  30s

```




* kong 环境： 在gateway service上启用 Request Termination、Correlation ID插件；
* kong 结果： 10服务器  20% <  cpu < 30%

```console
wuban@node-220:/data/benchmark/http$ ./k6 run --vus 100   --duration 30s http.js 

          /\      |‾‾| /‾‾/   /‾‾/   
     /\  /  \     |  |/  /   /  /    
    /  \/    \    |     (   /   ‾‾\  
   /          \   |  |\  \ |  (‾)  | 
  / __________ \  |__| \__\ \_____/ .io

  execution: local
     script: http.js
     output: -

  scenarios: (100.00%) 1 scenario, 100 max VUs, 1m0s max duration (incl. graceful stop):
           * default: 100 looping VUs for 30s (gracefulStop: 30s)


     ✓ status is 200

     checks.........................: 100.00% ✓ 1917517      ✗ 0      
     data_received..................: 3.4 GB  112 MB/s
     data_sent......................: 619 MB  21 MB/s
     http_req_blocked...............: avg=3.75µs  min=1.15µs   med=2.06µs  max=15.22ms  p(90)=3.2µs    p(95)=4.15µs  
     http_req_connecting............: avg=945ns   min=0s       med=0s      max=8.9ms    p(90)=0s       p(95)=0s      
     http_req_duration..............: avg=1.43ms  min=336.21µs med=1.27ms  max=240.02ms p(90)=2.26ms   p(95)=2.84ms  
       { expected_response:true }...: avg=1.43ms  min=336.21µs med=1.27ms  max=240.02ms p(90)=2.26ms   p(95)=2.84ms  
     http_req_failed................: 0.00%   ✓ 0            ✗ 1917517
     http_req_receiving.............: avg=86.74µs min=13.14µs  med=68.15µs max=33.31ms  p(90)=140.71µs p(95)=155.97µs
     http_req_sending...............: avg=17.81µs min=7.43µs   med=12.38µs max=15.12ms  p(90)=21.24µs  p(95)=27.21µs 
     http_req_tls_handshaking.......: avg=0s      min=0s       med=0s      max=0s       p(90)=0s       p(95)=0s      
     http_req_waiting...............: avg=1.32ms  min=282.51µs med=1.17ms  max=239.99ms p(90)=2.14ms   p(95)=2.69ms  
     http_reqs......................: 1917517 63913.937413/s
     iteration_duration.............: avg=1.55ms  min=439µs    med=1.38ms  max=240.11ms p(90)=2.39ms   p(95)=3ms     
     iterations.....................: 1917517 63913.937413/s
     vus............................: 100     min=100        max=100  
     vus_max........................: 100     min=100        max=100  


running (0m30.0s), 000/100 VUs, 1917517 complete and 0 interrupted iterations
default ✓ [======================================] 100 VUs  30s
```





* kong 环境：在gateway service上启用 Request Termination、Correlation ID、Key Authentication插件；
* kong 结果： 10服务器 25% <  cpu < 30%


```console

wuban@node-220:/data/benchmark/http$ ./k6 run --vus 100   --duration 30s http.js 

          /\      |‾‾| /‾‾/   /‾‾/   
     /\  /  \     |  |/  /   /  /    
    /  \/    \    |     (   /   ‾‾\  
   /          \   |  |\  \ |  (‾)  | 
  / __________ \  |__| \__\ \_____/ .io

  execution: local
     script: http.js
     output: -

  scenarios: (100.00%) 1 scenario, 100 max VUs, 1m0s max duration (incl. graceful stop):
           * default: 100 looping VUs for 30s (gracefulStop: 30s)


     ✓ status is 200

     checks.........................: 100.00% ✓ 1757364      ✗ 0      
     data_received..................: 3.4 GB  113 MB/s
     data_sent......................: 568 MB  19 MB/s
     http_req_blocked...............: avg=3.78µs  min=1.33µs   med=2.06µs  max=7.49ms  p(90)=3.27µs   p(95)=4.26µs  
     http_req_connecting............: avg=986ns   min=0s       med=0s      max=7.44ms  p(90)=0s       p(95)=0s      
     http_req_duration..............: avg=1.57ms  min=361.92µs med=1.36ms  max=26.98ms p(90)=2.55ms   p(95)=3ms     
       { expected_response:true }...: avg=1.57ms  min=361.92µs med=1.36ms  max=26.98ms p(90)=2.55ms   p(95)=3ms     
     http_req_failed................: 0.00%   ✓ 0            ✗ 1757364
     http_req_receiving.............: avg=92.05µs min=13.34µs  med=74.34µs max=17.4ms  p(90)=143.01µs p(95)=158.34µs
     http_req_sending...............: avg=18.19µs min=6.58µs   med=12.45µs max=7.02ms  p(90)=21.54µs  p(95)=27.87µs 
     http_req_tls_handshaking.......: avg=0s      min=0s       med=0s      max=0s      p(90)=0s       p(95)=0s      
     http_req_waiting...............: avg=1.46ms  min=290.3µs  med=1.25ms  max=16.25ms p(90)=2.44ms   p(95)=2.86ms  
     http_reqs......................: 1757364 58575.378431/s
     iteration_duration.............: avg=1.69ms  min=477.4µs  med=1.48ms  max=27.1ms  p(90)=2.67ms   p(95)=3.16ms  
     iterations.....................: 1757364 58575.378431/s
     vus............................: 100     min=100        max=100  
     vus_max........................: 100     min=100        max=100  


running (0m30.0s), 000/100 VUs, 1757364 complete and 0 interrupted iterations
default ✓ [======================================] 100 VUs  30s

```










