import http from 'k6/http';
import { check } from "k6";


export const options = {
  // A number specifying the number of VUs to run concurrently.
  vus: 10,
  // A string specifying the total duration of the test run.
  duration: '30s',

  // The following section contains configuration options for execution of this
  // test script in Grafana Cloud.
  //
  // See https://grafana.com/docs/grafana-cloud/k6/get-started/run-cloud-tests-from-the-cli/
  // to learn about authoring and running k6 test scripts in Grafana k6 Cloud.
  //
  // ext: {
  //   loadimpact: {
  //     // The ID of the project to which the test is assigned in the k6 Cloud UI.
  //     // By default tests are executed in default project.
  //     projectID: "",
  //     // The name of the test in the k6 Cloud UI.
  //     // Test runs with the same name will be grouped.
  //     name: "script.js"
  //   }
  // },

  // Uncomment this section to enable the use of Browser API in your tests.
  //
  // See https://grafana.com/docs/k6/latest/using-k6-browser/running-browser-tests/ to learn more
  // about using Browser API in your test scripts.
  //
  scenarios: {
    // The scenario name appears in the result summary, tags, and so on.
    // You can give the scenario any name, as long as each name in the script is unique.
    ui: {
      // Executor is a mandatory parameter for browser-based tests.
      // Shared iterations in this case tells k6 to reuse VUs to execute iterations.
      //
      // See https://grafana.com/docs/k6/latest/using-k6/scenarios/executors/ for other executor types.
      executor: 'shared-iterations',
      options: {
        browser: {
          // This is a mandatory parameter that instructs k6 to launch and
          // connect to a chromium-based browser, and use it to run UI-based
          // tests.
          type: 'chromium',
        },
      },
    },
  }
};

// The function that defines VU logic.
//
// See https://grafana.com/docs/k6/latest/examples/get-started-with-k6/ to learn more
// about authoring k6 scripts.
//



// curl http://192.168.1.10:8000/api/v1/demianhjw/aigic/0129 -H "Content-Type: application/json" -H "apikey: fhqU5VwqU2tdMxU6pX0tw0kj2E9wqdsF" -H "sync:true" -d '{
//     "model_name": "Realistic_Vision_V1.4",
//     "model_type": "tex2img",
//     "desc": {
//         "prompt": " a small car",
//         "steps": 20
//         }
// }'




export default function() {

      // Send a JSON encoded POST request
  let body = JSON.stringify({
    "model_name": "Realistic_Vision_V1.4",
    "model_type": "tex2img",
    "desc": {
        "prompt": " a small car",
        "steps": 20
        }
});

  let res = http.post('http://192.168.1.220:8000/api/v1/demianhjw/aigic/0129', body, { headers:
   { "Content-Type": "application/json",
   "apikey":"6r9aCCENYah5KPARJ4GLFmlOLs0uAEr2",
   "async":"true"}
  });

    // Use JSON.parse to deserialize the JSON (instead of using the r.json() method)
    //let j = JSON.parse(res.body);

    //console.log(res.body)

    // Verify response
    check(res, {
        "status is 200": (r) => r.status === 200,
       // "is key correct": (r) => j.json.key === "value",
    });
}
