package cachedata

import (
	"encoding/json"
	"github.com/odysseus/payment/model"
	"strconv"
)

func (c *CacheData) getUserLevelAndTaskTypeFromRedis(level int64, taskTypeId int64) (*model.UserLevelTaskType, error) {
	ulk := "level-task-type:" + strconv.FormatInt(level, 10) + "-" + strconv.FormatInt(taskTypeId, 10)
	if data, err := c.rdb.Get(c.ctx, ulk).Result(); err == nil {
		var userLevelAndTaskType = new(model.UserLevelTaskType)
		if err = json.Unmarshal([]byte(data), userLevelAndTaskType); err == nil {
			return userLevelAndTaskType, nil
		}
		return nil, err
	} else {
		return nil, err
	}
}

func (c *CacheData) getUserLevelAndTaskTypeFromDb(level int64, taskTypeId int64) (*model.UserLevelTaskType, error) {
	if userLevelAndTaskType, err := c.userAndTaskRepo.GetByTaskTypeAndUserLevel(taskTypeId, level); err == nil {
		return userLevelAndTaskType, nil
	} else {
		return nil, err
	}
}

func (c *CacheData) setUserLevelAndTaskTypeToRedis(d *model.UserLevelTaskType) error {
	ulk := "level-task-type:" + strconv.FormatInt(d.UserLevel, 10) + "-" + strconv.FormatInt(d.TaskTypeId, 10)
	if data, err := json.Marshal(d); err == nil {
		if err = c.rdb.Set(c.ctx, ulk, string(data), 0).Err(); err == nil {
			return nil
		}
		return err
	} else {
		return err
	}
}

func (c *CacheData) GetUserLevelAndTaskTypeByLevelIdAndTaskTypeId(levelId int64, taskTypeId int64) (*model.UserLevelTaskType, error) {
	// get from redis by level.
	// if not found in redis, get from db and then add to redis.
	if userLevelAndTaskType, err := c.getUserLevelAndTaskTypeFromRedis(levelId, taskTypeId); err == nil {
		return userLevelAndTaskType, nil
	}
	if userLevelAndTaskType, err := c.getUserLevelAndTaskTypeFromDb(levelId, taskTypeId); err == nil {
		if err = c.setUserLevelAndTaskTypeToRedis(userLevelAndTaskType); err == nil {
			return userLevelAndTaskType, nil
		}
		return nil, err
	} else {
		return nil, err
	}
}
