package model

import (
	"github.com/astaxie/beego/orm"
	"time"
)

type TaskType struct {
	ID              int64     `gorm:"column:id" db:"id" json:"id" form:"id"`             //  任务类型id
	Desc            string    `gorm:"column:desc" db:"desc" json:"desc" form:"desc"`     //  任务类型描述
	Price           int64     `gorm:"column:price" db:"price" json:"price" form:"price"` //  该任务类型的费用
	Complexity      int64     `gorm:"column:complexity" db:"complexity" json:"complexity" form:"complexity"`
	HardwareRequire string    `gorm:"column:hardware_require" db:"hardware_require" json:"hardware_require" form:"hardware_require"`
	ImageId         string    `gorm:"column:image_id" db:"image_id" json:"image_id" form:"image_id"`
	ImageUrl        string    `gorm:"column:image_url" db:"image_url" json:"image_url" form:"image_url"`
	Cmd             string    `gorm:"column:cmd" db:"cmd" json:"cmd" form:"cmd"`
	Workload        int64     `gorm:"column:workload" db:"workload" json:"workload" form:"workload"`
	ApiPath         string    `gorm:"column:api_path" db:"api_path" json:"api_path" form:"api_path"`
	CreatedTime     time.Time `gorm:"column:created_time" db:"created_time" json:"created_time" form:"created_time"` //  创建时间
	UpdatedTime     time.Time `gorm:"column:updated_time" db:"updated_time" json:"updated_time" form:"updated_time"` //  更新时间
	Deleted         int64     `gorm:"column:deleted" db:"deleted" json:"deleted" form:"deleted"`                     //  逻辑删除
}

func (TaskType) TableName() string {
	return "task_type"
}

type TaskTypeRepository interface {
	Create(taskType *TaskType) error
	GetById(id int64) (*TaskType, error)
	GetByApiPath(path string) (*TaskType, error)
	GetListByFilter(filters ...interface{}) []*TaskType
	Update(taskType *TaskType) error
	Delete(taskType *TaskType) error
}

type taskTypeRepositoryImpl struct {
	o orm.Ormer
}

func NewTaskTypeRepository() TaskTypeRepository {
	o := orm.NewOrm()
	return &taskTypeRepositoryImpl{o}
}

func (repo *taskTypeRepositoryImpl) Create(taskType *TaskType) error {
	_, err := repo.o.Insert(taskType)
	return err
}

func (repo *taskTypeRepositoryImpl) GetListByFilter(filters ...interface{}) []*TaskType {
	list := make([]*TaskType, 0)
	query := orm.NewOrm().QueryTable(new(TaskType).TableName())
	if len(filters) > 0 {
		l := len(filters)
		for k := 0; k < l; k += 2 {
			query = query.Filter(filters[k].(string), filters[k+1])
		}
	}
	query.OrderBy("-id").All(&list)
	return list
}

func (repo *taskTypeRepositoryImpl) GetById(id int64) (*TaskType, error) {
	taskType := TaskType{ID: id}
	err := repo.o.Read(&taskType)
	if err != nil {
		return nil, err
	}
	return &taskType, nil
}

func (repo *taskTypeRepositoryImpl) GetByApiPath(path string) (*TaskType, error) {
	taskType := TaskType{ApiPath: path}
	err := repo.o.Read(&taskType)
	if err != nil {
		return nil, err
	}
	return &taskType, nil
}

func (repo *taskTypeRepositoryImpl) Update(taskType *TaskType) error {
	_, err := repo.o.Update(taskType)
	return err
}

func (repo *taskTypeRepositoryImpl) Delete(taskType *TaskType) error {
	_, err := repo.o.Delete(taskType)
	return err
}
