package model

import (
	"github.com/astaxie/beego/orm"
	"time"
)

type User struct {
	ID               int64     `gorm:"column:id" db:"id" json:"id" form:"id"`                                                                 //  用户id
	Name             string    `gorm:"column:name" db:"name" json:"name" form:"name"`                                                         //  开发者名称
	Phone            string    `gorm:"column:phone" db:"phone" json:"phone" form:"phone"`                                                     //  电话
	Mail             string    `gorm:"column:mail" db:"mail" json:"mail" form:"mail"`                                                         //  邮箱
	ChainAccount     string    `gorm:"column:chain_account" db:"chain_account" json:"chain_account" form:"chain_account"`                     //  区块链账号
	Type             int64     `gorm:"column:type" db:"type" json:"type" form:"type"`                                                         //  用户类型：\n1=自然人\n2=企业
	IsAuthed         int64     `gorm:"column:is_authed" db:"is_authed" json:"is_authed" form:"is_authed"`                                     //  是否实名
	RegisterFrom     int64     `gorm:"column:register_from" db:"register_from" json:"register_from" form:"register_from"`                     //  注册来源，三方账号
	RegisterFromDesc string    `gorm:"column:register_from_desc" db:"register_from_desc" json:"register_from_desc" form:"register_from_desc"` //  三方账户描述
	Username         string    `gorm:"column:username" db:"username" json:"username" form:"username"`                                         //  开发者平台用户名
	Balance          int64     `gorm:"column:balance" db:"balance" json:"balance" form:"balance"`                                             //  用户账户余额
	Level            int64     `gorm:"column:level" db:"level" json:"level" form:"level"`                                                     //  信用等级，决定免费调用额度
	CustomId         string    `gorm:"column:custom_id" db:"custom_id" json:"custom_id" form:"custom_id"`                                     //  自定义kong的id
	VerifierId       string    `gorm:"column:verifier_id" db:"verifier_id" json:"verifier_id" form:"verifier_id"`
	ProfileImage     string    `gorm:"column:profile_image" db:"profile_image" json:"profile_image" form:"profile_image"`
	CreatedTime      time.Time `gorm:"column:created_time" db:"created_time" json:"created_time" form:"created_time"` //  创建时间
	UpdatedTime      time.Time `gorm:"column:updated_time" db:"updated_time" json:"updated_time" form:"updated_time"` //  更新时间
	Deleted          int64     `gorm:"column:deleted" db:"deleted" json:"deleted" form:"deleted"`                     //  逻辑删除
}

func (User) TableName() string {
	return "user"
}

type UserRepository interface {
	Create(user *User) error
	GetById(uid int64) (*User, error)
	GetListByFilter(filters ...interface{}) []*User
	Update(user *User) error
	Delete(user *User) error
}

type userRepositoryImpl struct {
	o orm.Ormer
}

func NewUserRepository() UserRepository {
	o := orm.NewOrm()
	return &userRepositoryImpl{o}
}

func (repo *userRepositoryImpl) Create(user *User) error {
	_, err := repo.o.Insert(user)
	return err
}

func (repo *userRepositoryImpl) GetListByFilter(filters ...interface{}) []*User {
	list := make([]*User, 0)
	query := orm.NewOrm().QueryTable(new(User).TableName())
	if len(filters) > 0 {
		l := len(filters)
		for k := 0; k < l; k += 2 {
			query = query.Filter(filters[k].(string), filters[k+1])
		}
	}
	query.OrderBy("-id").All(&list)
	return list
}

//// return balance, charge, credits and error.
//func (repo *userRepositoryImpl) GetPayInfoById(uid int64) (int64, int64, int64, error) {
//
//}

func (repo *userRepositoryImpl) GetById(uid int64) (*User, error) {
	user := User{ID: uid}
	err := repo.o.Read(&user)
	if err != nil {
		return nil, err
	}
	return &user, nil
}

func (repo *userRepositoryImpl) Update(user *User) error {
	_, err := repo.o.Update(user)
	return err
}

func (repo *userRepositoryImpl) Delete(user *User) error {
	_, err := repo.o.Delete(user)
	return err
}
