package model

import (
	"github.com/astaxie/beego/orm"
	_ "github.com/go-sql-driver/mysql"
	"time"
)

type UserLevelTaskType struct {
	ID                 int64     `gorm:"column:id" db:"id" json:"id" form:"id"`
	FreeCallCountDay   int64     `gorm:"column:free_call_count_day" db:"free_call_count_day" json:"free_call_count_day" form:"free_call_count_day"`
	FreeCallCountMonth int64     `gorm:"column:free_call_count_month" db:"free_call_count_month" json:"free_call_count_month" form:"free_call_count_month"`
	FreeCallCountYear  int64     `gorm:"column:free_call_count_year" db:"free_call_count_year" json:"free_call_count_year" form:"free_call_count_year"`
	FreeCallCountTotal int64     `gorm:"column:free_call_count_total" db:"free_call_count_total" json:"free_call_count_total" form:"free_call_count_total"`
	UserLevel          int64     `gorm:"column:user_level" db:"user_level" json:"user_level" form:"user_level"`
	TaskTypeId         int64     `gorm:"column:task_type_id" db:"task_type_id" json:"task_type_id" form:"task_type_id"`
	CreatedTime        time.Time `gorm:"column:created_time" db:"created_time" json:"created_time" form:"created_time"`
	UpdatedTime        time.Time `gorm:"column:updated_time" db:"updated_time" json:"updated_time" form:"updated_time"`
	Deleted            int64     `gorm:"column:deleted" db:"deleted" json:"deleted" form:"deleted"`
}

func (UserLevelTaskType) TableName() string {
	return "user_level_task_type"
}

type UserLevelTaskTypeRepository interface {
	Create(user *UserLevelTaskType) error
	GetById(uid int64) (*UserLevelTaskType, error)
	GetListByFilter(filters ...interface{}) []*UserLevelTaskType
	GetByTaskTypeAndUserLevel(taskType int64, userLevel int64) (*UserLevelTaskType, error)
	Update(user *UserLevelTaskType) error
	Delete(user *UserLevelTaskType) error
}

type userLevelTaskTypeRepositoryImpl struct {
	o orm.Ormer
}

func NewUserLevelTaskTypeRepository() UserLevelTaskTypeRepository {
	o := orm.NewOrm()
	return &userLevelTaskTypeRepositoryImpl{o}
}

func (repo *userLevelTaskTypeRepositoryImpl) Create(user *UserLevelTaskType) error {
	_, err := repo.o.Insert(user)
	return err
}

func (repo *userLevelTaskTypeRepositoryImpl) GetListByFilter(filters ...interface{}) []*UserLevelTaskType {
	list := make([]*UserLevelTaskType, 0)
	query := orm.NewOrm().QueryTable(new(UserLevelTaskType).TableName())
	if len(filters) > 0 {
		l := len(filters)
		for k := 0; k < l; k += 2 {
			query = query.Filter(filters[k].(string), filters[k+1])
		}
	}
	query.OrderBy("-id").All(&list)
	//total, _ := query.Count()
	return list
}

func (repo *userLevelTaskTypeRepositoryImpl) GetByTaskTypeAndUserLevel(taskType int64, userLevel int64) (*UserLevelTaskType, error) {
	user := UserLevelTaskType{TaskTypeId: taskType, UserLevel: userLevel}
	err := repo.o.Read(&user)
	if err != nil {
		return nil, err
	}
	return &user, nil
}

func (repo *userLevelTaskTypeRepositoryImpl) GetById(uid int64) (*UserLevelTaskType, error) {
	user := UserLevelTaskType{ID: uid}
	err := repo.o.Read(&user)
	if err != nil {
		return nil, err
	}
	return &user, nil
}

func (repo *userLevelTaskTypeRepositoryImpl) Update(user *UserLevelTaskType) error {
	_, err := repo.o.Update(user)
	return err
}

// normally update user.deleted = 1 to soft-delete the record.
func (repo *userLevelTaskTypeRepositoryImpl) Delete(user *UserLevelTaskType) error {
	_, err := repo.o.Delete(user)
	return err
}
