package model

import "testing"

func init() {
	DbInit(DbConfig{
		Host:   "192.168.1.211",
		Port:   3306,
		User:   "root",
		Passwd: "12345678",
		DbName: "liuxuzhong",
	})
}

func TestNewUserLevelRepository(t *testing.T) {
	repo := NewUserLevelRepository()
	if repo == nil {
		t.Error("NewUserLevelRepository failed")
	}
	record, err := repo.GetByLevel(0)
	if err != nil {
		t.Fatal(err)
	}
	if record == nil {
		t.Error("record is nil")
	}
}

func TestNewTaskTypeRepository(t *testing.T) {
	repo := NewTaskTypeRepository()
	if repo == nil {
		t.Error("NewTaskTypeRepository failed")
	}
	record, err := repo.GetByApiPath("/start/docker")
	if err != nil {
		t.Fatal(err)
	}
	if record == nil {
		t.Error("record is nil")
	}
}

func TestNewUserRepository(t *testing.T) {
	repo := NewUserRepository()
	if repo == nil {
		t.Error("NewUserRepository failed")
	}
	record, err := repo.GetById(17)
	if err != nil {
		t.Fatal(err)
	}
	if record == nil {
		t.Error("record is nil")
	}
}

func TestNewUserLevelTaskTypeRepository(t *testing.T) {
	repo := NewUserLevelTaskTypeRepository()
	if repo == nil {
		t.Error("NewUserLevelTaskTypeRepository failed")
	}
	record, err := repo.GetByTaskTypeAndUserLevel(1, 1)
	if err != nil {
		t.Fatal(err)
	}
	if record == nil {
		t.Error("record is nil")
	}
}
