package model

import (
	"github.com/astaxie/beego/orm"
	"time"
)

type TaskType struct {
	ID              int64     `orm:"column(id)" db:"id" json:"id" form:"id"`             //  任务类型id
	Desc            string    `orm:"column(desc)" db:"desc" json:"desc" form:"desc"`     //  任务类型描述
	Price           int64     `orm:"column(price)" db:"price" json:"price" form:"price"` //  该任务类型的费用
	Complexity      int64     `orm:"column(complexity)" db:"complexity" json:"complexity" form:"complexity"`
	PublicKey       string    `orm:"column(public_key)" db:"public_key" json:"public_key" form:"public_key"`
	HardwareRequire string    `orm:"column(hardware_require)" db:"hardware_require" json:"hardware_require" form:"hardware_require"`
	ImageId         string    `orm:"column(image_id)" db:"image_id" json:"image_id" form:"image_id"`
	ImageUrl        string    `orm:"column(image_url)" db:"image_url" json:"image_url" form:"image_url"`
	Cmd             string    `orm:"column(cmd)" db:"cmd" json:"cmd" form:"cmd"`
	Workload        int64     `orm:"column(workload)" db:"workload" json:"workload" form:"workload"`
	ApiPath         string    `orm:"column(api_path)" db:"api_path" json:"api_path" form:"api_path"`
	ImageName       string    `orm:"column(image_name)" db:"image_name" json:"image_name" form:"image_name"`
	SignUrl         string    `orm:"column(sign_url)" db:"sign_url" json:"sign_url" form:"sign_url"`
	Username        string    `orm:"column(username)" db:"username" json:"username" form:"username"`
	Password        string    `orm:"column(password)" db:"password" json:"password" form:"password"`
	CreatedTime     time.Time `orm:"column(created_time)" db:"created_time" json:"created_time" form:"created_time"` //  创建时间
	UpdatedTime     time.Time `orm:"column(updated_time)" db:"updated_time" json:"updated_time" form:"updated_time"` //  更新时间
	Deleted         int64     `orm:"column(deleted)" db:"deleted" json:"deleted" form:"deleted"`                     //  逻辑删除
}

func (TaskType) TableName() string {
	return "task_type"
}

type TaskTypeRepository interface {
	Create(taskType *TaskType) error
	GetById(id int64) (*TaskType, error)
	GetByApiPath(path string) (*TaskType, error)
	GetListByFilter(filters ...interface{}) []*TaskType
	Update(taskType *TaskType) error
	Delete(taskType *TaskType) error
}

type taskTypeRepositoryImpl struct {
	o orm.Ormer
}

func NewTaskTypeRepository() TaskTypeRepository {
	o := orm.NewOrm()
	return &taskTypeRepositoryImpl{o}
}

func (repo *taskTypeRepositoryImpl) Create(taskType *TaskType) error {
	_, err := repo.o.Insert(taskType)
	return err
}

func (repo *taskTypeRepositoryImpl) GetListByFilter(filters ...interface{}) []*TaskType {
	list := make([]*TaskType, 0)
	query := orm.NewOrm().QueryTable(new(TaskType).TableName())
	if len(filters) > 0 {
		l := len(filters)
		for k := 0; k < l; k += 2 {
			query = query.Filter(filters[k].(string), filters[k+1])
		}
	}
	query.OrderBy("-id").All(&list)
	return list
}

func (repo *taskTypeRepositoryImpl) GetById(id int64) (*TaskType, error) {
	taskType := TaskType{ID: id}
	err := repo.o.Read(&taskType, "id")
	if err != nil {
		return nil, err
	}
	return &taskType, nil
}

func (repo *taskTypeRepositoryImpl) GetByApiPath(path string) (*TaskType, error) {
	taskType := TaskType{ApiPath: path}
	err := repo.o.Read(&taskType, "api_path")
	if err != nil {
		return nil, err
	}
	return &taskType, nil
}

func (repo *taskTypeRepositoryImpl) Update(taskType *TaskType) error {
	_, err := repo.o.Update(taskType)
	return err
}

func (repo *taskTypeRepositoryImpl) Delete(taskType *TaskType) error {
	_, err := repo.o.Delete(taskType)
	return err
}
