package model

import (
	"github.com/astaxie/beego/orm"
	"time"
)

type UserLevel struct {
	ID                 int64     `orm:"column(id)" db:"id" json:"id" form:"id"`                                                                     //  信用等级id
	Level              int64     `orm:"column(level)" db:"level" json:"level" form:"level"`                                                         //  等级
	Desc               string    `orm:"column(desc)" db:"desc" json:"desc" form:"desc"`                                                             //  描述
	CreditQuota        int64     `orm:"column(credit_quota)" db:"credit_quota" json:"credit_quota" form:"credit_quota"`                             //  该等级免费额度
	FreeCallCountDay   int64     `orm:"column(free_call_count_day)" db:"free_call_count_day" json:"free_call_count_day" form:"free_call_count_day"` //  免费调用次数
	FreeCallCountMonth int64     `orm:"column(free_call_count_month)" db:"free_call_count_month" json:"free_call_count_month" form:"free_call_count_month"`
	FreeCallCountYear  int64     `orm:"column(free_call_count_year)" db:"free_call_count_year" json:"free_call_count_year" form:"free_call_count_year"`
	FreeCallCountTotal int64     `orm:"column(free_call_count_total)" db:"free_call_count_total" json:"free_call_count_total" form:"free_call_count_total"`
	RateLimitSecond    int64     `orm:"column(rate_limit_second)" db:"rate_limit_second" json:"rate_limit_second" form:"rate_limit_second"` //  该等级调用频率
	RateLimitMinute    int64     `orm:"column(rate_limit_minute)" db:"rate_limit_minute" json:"rate_limit_minute" form:"rate_limit_minute"`
	RateLimitHour      int64     `orm:"column(rate_limit_hour)" db:"rate_limit_hour" json:"rate_limit_hour" form:"rate_limit_hour"`
	RateLimitDay       int64     `orm:"column(rate_limit_day)" db:"rate_limit_day" json:"rate_limit_day" form:"rate_limit_day"`
	RateLimitMonth     int64     `orm:"column(rate_limit_month)" db:"rate_limit_month" json:"rate_limit_month" form:"rate_limit_month"`
	RateLimitYear      int64     `orm:"column(rate_limit_year)" db:"rate_limit_year" json:"rate_limit_year" form:"rate_limit_year"`
	CreatedTime        time.Time `orm:"column(created_time)" db:"created_time" json:"created_time" form:"created_time"` //  创建时间
	UpdatedTime        time.Time `orm:"column(updated_time)" db:"updated_time" json:"updated_time" form:"updated_time"` //  更新时间
	Deleted            int64     `orm:"column(deleted)" db:"deleted" json:"deleted" form:"deleted"`                     //  逻辑删除
}

func (UserLevel) TableName() string {
	return "user_level"
}

type UserLevelRepository interface {
	Create(user *UserLevel) error
	GetById(uid int64) (*UserLevel, error)
	GetByLevel(level int64) (*UserLevel, error)
	GetListByFilter(filters ...interface{}) []*UserLevel
	Update(user *UserLevel) error
	Delete(user *UserLevel) error
}

type userLevelRepositoryImpl struct {
	o orm.Ormer
}

func NewUserLevelRepository() UserLevelRepository {
	o := orm.NewOrm()
	return &userLevelRepositoryImpl{o}
}

func (repo *userLevelRepositoryImpl) Create(user *UserLevel) error {
	_, err := repo.o.Insert(user)
	return err
}

func (repo *userLevelRepositoryImpl) GetListByFilter(filters ...interface{}) []*UserLevel {
	list := make([]*UserLevel, 0)
	query := orm.NewOrm().QueryTable(new(UserLevel).TableName())
	if len(filters) > 0 {
		l := len(filters)
		for k := 0; k < l; k += 2 {
			query = query.Filter(filters[k].(string), filters[k+1])
		}
	}
	query.OrderBy("-id").All(&list)
	return list
}

func (repo *userLevelRepositoryImpl) GetById(uid int64) (*UserLevel, error) {
	user := UserLevel{ID: uid}
	err := repo.o.Read(&user, "id")
	if err != nil {
		return nil, err
	}
	return &user, nil
}

func (repo *userLevelRepositoryImpl) GetByLevel(level int64) (*UserLevel, error) {
	user := UserLevel{Level: level}
	err := repo.o.Read(&user, "level")
	if err != nil {
		return nil, err
	}
	return &user, nil
}

func (repo *userLevelRepositoryImpl) Update(user *UserLevel) error {
	_, err := repo.o.Update(user)
	return err
}

func (repo *userLevelRepositoryImpl) Delete(user *UserLevel) error {
	_, err := repo.o.Delete(user)
	return err
}
