package cachedata

import (
	"context"
	lru "github.com/hashicorp/golang-lru"
	"github.com/odysseus/payment/model"
	goredislib "github.com/redis/go-redis/v9"
)

type CacheData struct {
	rdb        *goredislib.Client
	pathLru    *lru.Cache
	ctx        context.Context
	cancel     context.CancelFunc
	maxRoutine int
	taskChan   chan QueryParam

	taskType        model.TaskTypeRepository
	userRepo        model.UserRepository
	userLevel       model.UserLevelRepository
	userAndTaskRepo model.UserLevelTaskTypeRepository
}

type RedisConnParam struct {
	Addr     string
	Password string
	DbIndex  int
}

func NewCacheData(ctx context.Context, options RedisConnParam, mysqlConfig model.DbConfig) *CacheData {
	model.DbInit(mysqlConfig)
	rdb := goredislib.NewClient(&goredislib.Options{
		Addr:     options.Addr,
		Password: options.Password,
		DB:       options.DbIndex,
		PoolSize: 100,
		Protocol: 3,
	})
	pathLru, _ := lru.New(10000)
	cache := &CacheData{
		rdb:             rdb,
		pathLru:         pathLru,
		maxRoutine:      10,
		taskChan:        make(chan QueryParam, 10000),
		taskType:        model.NewTaskTypeRepository(),
		userRepo:        model.NewUserRepository(),
		userLevel:       model.NewUserLevelRepository(),
		userAndTaskRepo: model.NewUserLevelTaskTypeRepository(),
	}
	cache.ctx, cache.cancel = context.WithCancel(ctx)
	for i := 0; i < cache.maxRoutine; i++ {
		go cache.queryRoutine()
	}
	return cache
}
