package cachedata

import (
	"context"
	"github.com/odysseus/payment/model"
	"testing"
)

var (
	_cache *CacheData
)

func newCache() *CacheData {
	if _cache != nil {
		return _cache
	}
	_cache = NewCacheData(context.Background(), RedisConnParam{
		Addr:     "192.168.1.10:6379",
		Password: "",
		DbIndex:  0,
	}, model.DbConfig{
		Host:   "192.168.1.211",
		Port:   3306,
		DbName: "liuxuzhong",
		Passwd: "12345678",
		User:   "root",
	})
	return _cache
}

func TestCacheData_Query(t *testing.T) {
	cache := newCache()

	testPath := "/start/docker"
	testUid := int64(19)

	task, err := cache.Query(testPath, testUid)
	if err != nil {
		t.Error(err)
	}
	t.Log(task)
}

func TestCacheData_MQuery(t *testing.T) {
	cache := newCache()
	testPaths := []string{
		"path1",
		"path2",
		"path3",
	}
	testUids := []int64{
		1,
		2,
		3,
	}
	taskChan, err := cache.MQuery(testPaths, testUids)
	if err != nil {
		t.Error(err)
	}
	count := 0
	for task := range taskChan {
		count++
		t.Log(task)
		if count == len(testPaths) {
			break
		}
	}
}

func TestCacheData_SetUserInfo(t *testing.T) {
	cache := newCache()
	testUid := int64(1)

	user, err := cache.GetUserInfo(testUid)
	if err != nil {
		t.Error(err)
	}
	t.Log(user)
}

func TestCacheData_GetUserInfo(t *testing.T) {
	cache := newCache()
	testUid := int64(18)

	user, err := cache.GetUserInfo(testUid)
	if err != nil {
		t.Error(err)
	}
	t.Log(user)
}
func TestCacheData_UpdateUserBalance(t *testing.T) {
	cache := newCache()
	testUid := int64(1)
	testBalance := 100

	err := cache.UpdateUserBalance(testUid, testBalance)
	if err != nil {
		t.Error(err)
	}
}

func TestCacheData_UpdateUserLevel(t *testing.T) {
	cache := newCache()
	testUid := int64(1)
	testLevel := 1

	err := cache.UpdateUserLevel(testUid, testLevel)
	if err != nil {
		t.Error(err)
	}
}

func TestCacheData_UpdateUserDeleted(t *testing.T) {
	cache := newCache()
	testUid := int64(1)
	testDeleted := 1

	err := cache.UpdateUserDeleted(testUid, testDeleted)
	if err != nil {
		t.Error(err)
	}
}

func TestCacheData_UpdateUserBalanceAndLevel(t *testing.T) {
	cache := newCache()
	testUid := int64(1)
	testBalance := 100
	testLevel := 1

	// update balance first
	err := cache.UpdateUserBalance(testUid, testBalance)
	if err != nil {
		t.Error(err)
	}
	// update level second.
	err = cache.UpdateUserLevel(testUid, testLevel)
	if err != nil {
		t.Error(err)
	}
}
