package cachedata

import (
	"encoding/json"
	"github.com/odysseus/payment/model"
	"strconv"
)

func (c *CacheData) getUserLevelFromRedis(level int64) (*model.UserLevel, error) {
	ulk := "level-info:" + strconv.FormatInt(level, 10)
	if data, err := c.rdb.Get(c.ctx, ulk).Result(); err == nil {
		var userLevel = new(model.UserLevel)
		if err = json.Unmarshal([]byte(data), userLevel); err == nil {
			return userLevel, nil
		}
		return nil, err
	} else {
		return nil, err
	}
}

func (c *CacheData) getUserLevelFromDb(level int64) (*model.UserLevel, error) {
	if userLevel, err := c.userLevel.GetByLevel(level); err == nil {
		return userLevel, nil
	} else {
		return nil, err
	}
}

// implement setUserLevelToRedis
func (c *CacheData) setUserLevelToRedis(d *model.UserLevel) error {
	ulk := "level-info:" + strconv.FormatInt(d.Level, 10)
	if data, err := json.Marshal(d); err == nil {
		if err = c.rdb.Set(c.ctx, ulk, string(data), 0).Err(); err == nil {
			return nil
		}
		return err
	} else {
		return err
	}
}

func (c *CacheData) GetUserLevelInfoByLevelId(level int64) (*model.UserLevel, error) {
	// get from redis by level.
	// if not found in redis, get from db and then add to redis.
	if userLevel, err := c.getUserLevelFromRedis(level); err == nil {
		return userLevel, nil
	}
	if userLevel, err := c.getUserLevelFromDb(level); err == nil {
		if err = c.setUserLevelToRedis(userLevel); err == nil {
			return userLevel, nil
		}
		return nil, err
	} else {
		return nil, err
	}
}
