// We require the Hardhat Runtime Environment explicitly here. This is optional
// but useful for running the script in a standalone fashion through `node <script>`.
//
// You can also run a script with `npx hardhat run <script>`. If you do that, Hardhat
// will compile your contracts, add the Hardhat Runtime Environment's members to the
// global scope, and execute the script.
// const hre = require("hardhat");

const {ethers} = require("hardhat")

async function main() {
  // 部署 storage
  const Storage = await ethers.getContractFactory("AddressStorage");
  const storage = await Storage.deploy();
  await storage.waitForDeployment();
  console.log(`Storage deployed to ${storage.target}`);
  // 部署 storage 结束

  // 部署 Validator
  const Validator = await ethers.getContractFactory("Validator");
  const validator = await Validator.deploy();
  await validator.waitForDeployment();
  console.log(`Validator deployed to ${validator.target}`);
  // 部署 Validator 结束

  // 部署 Distribution
  const Distribution = await ethers.getContractFactory("Distribution");
  const distribution = await Distribution.deploy(await validator.getAddress());
  await distribution.waitForDeployment();
  console.log(`Distribution deployed to ${distribution.target}`);
  // 部署 Distribution 结束
}

// We recommend this pattern to be able to use async/await everywhere
// and properly handle errors.
main().catch((error) => {
  console.error(error);
  process.exitCode = 1;
});

// Storage deployed to 0xA0ec84eCa14CD23afD5D7ba973390E83F0Cbe89A
// Validator deployed to 0x7CBD03ecfA9093F83150E9625A25B00F555c81F7
// Distribution deployed to 0xb85D8fD67b286632FbeBdAE36fdA135e97391f0D