// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package aon_user

import (
	"errors"
	"math/big"
	"strings"

	ethereum "github.com/ethereum/go-ethereum"
	"github.com/ethereum/go-ethereum/accounts/abi"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"github.com/ethereum/go-ethereum/event"
)

// Reference imports to suppress errors if they are not otherwise used.
var (
	_ = errors.New
	_ = big.NewInt
	_ = strings.NewReader
	_ = ethereum.NotFound
	_ = bind.Bind
	_ = common.Big1
	_ = types.BloomLookup
	_ = event.NewSubscription
	_ = abi.ConvertType
)

// AonUserMetaData contains all meta data concerning the AonUser contract.
var AonUserMetaData = &bind.MetaData{
	ABI: "[{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"address\",\"name\":\"owner\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"address\",\"name\":\"approved\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"}],\"name\":\"Approval\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"address\",\"name\":\"owner\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"address\",\"name\":\"operator\",\"type\":\"address\"},{\"indexed\":false,\"internalType\":\"bool\",\"name\":\"approved\",\"type\":\"bool\"}],\"name\":\"ApprovalForAll\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"address\",\"name\":\"addr\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"string\",\"name\":\"userId\",\"type\":\"string\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"loginTime\",\"type\":\"uint256\"}],\"name\":\"Login\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"address\",\"name\":\"addr\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"string\",\"name\":\"userId\",\"type\":\"string\"},{\"indexed\":false,\"internalType\":\"string\",\"name\":\"userInviter\",\"type\":\"string\"},{\"indexed\":false,\"internalType\":\"string\",\"name\":\"userName\",\"type\":\"string\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"registerTime\",\"type\":\"uint256\"}],\"name\":\"Register\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"address\",\"name\":\"from\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"address\",\"name\":\"to\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"}],\"name\":\"Transfer\",\"type\":\"event\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"to\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"}],\"name\":\"approve\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"owner\",\"type\":\"address\"}],\"name\":\"balanceOf\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"balance\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"}],\"name\":\"getApproved\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"operator\",\"type\":\"address\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"string\",\"name\":\"_userId\",\"type\":\"string\"}],\"name\":\"getBalances\",\"outputs\":[{\"internalType\":\"string[]\",\"name\":\"_symbols\",\"type\":\"string[]\"},{\"internalType\":\"string[]\",\"name\":\"_names\",\"type\":\"string[]\"},{\"internalType\":\"uint256[]\",\"name\":\"_balances\",\"type\":\"uint256[]\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"getOwnedUsers\",\"outputs\":[{\"internalType\":\"string[]\",\"name\":\"_userIds\",\"type\":\"string[]\"},{\"internalType\":\"string[]\",\"name\":\"_userNames\",\"type\":\"string[]\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"string\",\"name\":\"_user\",\"type\":\"string\"}],\"name\":\"getOwner\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"owner\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"operator\",\"type\":\"address\"}],\"name\":\"isApprovedForAll\",\"outputs\":[{\"internalType\":\"bool\",\"name\":\"\",\"type\":\"bool\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"string\",\"name\":\"_userId\",\"type\":\"string\"},{\"internalType\":\"string\",\"name\":\"_inviter\",\"type\":\"string\"}],\"name\":\"login\",\"outputs\":[{\"internalType\":\"bool\",\"name\":\"\",\"type\":\"bool\"}],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"addresspayable\",\"name\":\"_user\",\"type\":\"address\"},{\"internalType\":\"string\",\"name\":\"_userId\",\"type\":\"string\"},{\"internalType\":\"string\",\"name\":\"_inviter\",\"type\":\"string\"}],\"name\":\"loginByServer\",\"outputs\":[{\"internalType\":\"bool\",\"name\":\"\",\"type\":\"bool\"}],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"name\",\"outputs\":[{\"internalType\":\"string\",\"name\":\"\",\"type\":\"string\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"}],\"name\":\"ownerOf\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"owner\",\"type\":\"address\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"from\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"to\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"}],\"name\":\"safeTransferFrom\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"from\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"to\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"},{\"internalType\":\"bytes\",\"name\":\"data\",\"type\":\"bytes\"}],\"name\":\"safeTransferFrom\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"operator\",\"type\":\"address\"},{\"internalType\":\"bool\",\"name\":\"approved\",\"type\":\"bool\"}],\"name\":\"setApprovalForAll\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"bytes4\",\"name\":\"interfaceId\",\"type\":\"bytes4\"}],\"name\":\"supportsInterface\",\"outputs\":[{\"internalType\":\"bool\",\"name\":\"\",\"type\":\"bool\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"symbol\",\"outputs\":[{\"internalType\":\"string\",\"name\":\"\",\"type\":\"string\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"}],\"name\":\"tokenURI\",\"outputs\":[{\"internalType\":\"string\",\"name\":\"\",\"type\":\"string\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"from\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"to\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"}],\"name\":\"transferFrom\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"string\",\"name\":\"_user\",\"type\":\"string\"}],\"name\":\"userIdToTokenId\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"_user\",\"type\":\"uint256\"}],\"name\":\"userInviter\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"}]",
}

// AonUserABI is the input ABI used to generate the binding from.
// Deprecated: Use AonUserMetaData.ABI instead.
var AonUserABI = AonUserMetaData.ABI

// AonUser is an auto generated Go binding around an Ethereum contract.
type AonUser struct {
	AonUserCaller     // Read-only binding to the contract
	AonUserTransactor // Write-only binding to the contract
	AonUserFilterer   // Log filterer for contract events
}

// AonUserCaller is an auto generated read-only Go binding around an Ethereum contract.
type AonUserCaller struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// AonUserTransactor is an auto generated write-only Go binding around an Ethereum contract.
type AonUserTransactor struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// AonUserFilterer is an auto generated log filtering Go binding around an Ethereum contract events.
type AonUserFilterer struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// AonUserSession is an auto generated Go binding around an Ethereum contract,
// with pre-set call and transact options.
type AonUserSession struct {
	Contract     *AonUser          // Generic contract binding to set the session for
	CallOpts     bind.CallOpts     // Call options to use throughout this session
	TransactOpts bind.TransactOpts // Transaction auth options to use throughout this session
}

// AonUserCallerSession is an auto generated read-only Go binding around an Ethereum contract,
// with pre-set call options.
type AonUserCallerSession struct {
	Contract *AonUserCaller // Generic contract caller binding to set the session for
	CallOpts bind.CallOpts  // Call options to use throughout this session
}

// AonUserTransactorSession is an auto generated write-only Go binding around an Ethereum contract,
// with pre-set transact options.
type AonUserTransactorSession struct {
	Contract     *AonUserTransactor // Generic contract transactor binding to set the session for
	TransactOpts bind.TransactOpts  // Transaction auth options to use throughout this session
}

// AonUserRaw is an auto generated low-level Go binding around an Ethereum contract.
type AonUserRaw struct {
	Contract *AonUser // Generic contract binding to access the raw methods on
}

// AonUserCallerRaw is an auto generated low-level read-only Go binding around an Ethereum contract.
type AonUserCallerRaw struct {
	Contract *AonUserCaller // Generic read-only contract binding to access the raw methods on
}

// AonUserTransactorRaw is an auto generated low-level write-only Go binding around an Ethereum contract.
type AonUserTransactorRaw struct {
	Contract *AonUserTransactor // Generic write-only contract binding to access the raw methods on
}

// NewAonUser creates a new instance of AonUser, bound to a specific deployed contract.
func NewAonUser(address common.Address, backend bind.ContractBackend) (*AonUser, error) {
	contract, err := bindAonUser(address, backend, backend, backend)
	if err != nil {
		return nil, err
	}
	return &AonUser{AonUserCaller: AonUserCaller{contract: contract}, AonUserTransactor: AonUserTransactor{contract: contract}, AonUserFilterer: AonUserFilterer{contract: contract}}, nil
}

// NewAonUserCaller creates a new read-only instance of AonUser, bound to a specific deployed contract.
func NewAonUserCaller(address common.Address, caller bind.ContractCaller) (*AonUserCaller, error) {
	contract, err := bindAonUser(address, caller, nil, nil)
	if err != nil {
		return nil, err
	}
	return &AonUserCaller{contract: contract}, nil
}

// NewAonUserTransactor creates a new write-only instance of AonUser, bound to a specific deployed contract.
func NewAonUserTransactor(address common.Address, transactor bind.ContractTransactor) (*AonUserTransactor, error) {
	contract, err := bindAonUser(address, nil, transactor, nil)
	if err != nil {
		return nil, err
	}
	return &AonUserTransactor{contract: contract}, nil
}

// NewAonUserFilterer creates a new log filterer instance of AonUser, bound to a specific deployed contract.
func NewAonUserFilterer(address common.Address, filterer bind.ContractFilterer) (*AonUserFilterer, error) {
	contract, err := bindAonUser(address, nil, nil, filterer)
	if err != nil {
		return nil, err
	}
	return &AonUserFilterer{contract: contract}, nil
}

// bindAonUser binds a generic wrapper to an already deployed contract.
func bindAonUser(address common.Address, caller bind.ContractCaller, transactor bind.ContractTransactor, filterer bind.ContractFilterer) (*bind.BoundContract, error) {
	parsed, err := AonUserMetaData.GetAbi()
	if err != nil {
		return nil, err
	}
	return bind.NewBoundContract(address, *parsed, caller, transactor, filterer), nil
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_AonUser *AonUserRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _AonUser.Contract.AonUserCaller.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_AonUser *AonUserRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _AonUser.Contract.AonUserTransactor.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_AonUser *AonUserRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _AonUser.Contract.AonUserTransactor.contract.Transact(opts, method, params...)
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_AonUser *AonUserCallerRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _AonUser.Contract.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_AonUser *AonUserTransactorRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _AonUser.Contract.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_AonUser *AonUserTransactorRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _AonUser.Contract.contract.Transact(opts, method, params...)
}

// BalanceOf is a free data retrieval call binding the contract method 0x70a08231.
//
// Solidity: function balanceOf(address owner) view returns(uint256 balance)
func (_AonUser *AonUserCaller) BalanceOf(opts *bind.CallOpts, owner common.Address) (*big.Int, error) {
	var out []interface{}
	err := _AonUser.contract.Call(opts, &out, "balanceOf", owner)

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// BalanceOf is a free data retrieval call binding the contract method 0x70a08231.
//
// Solidity: function balanceOf(address owner) view returns(uint256 balance)
func (_AonUser *AonUserSession) BalanceOf(owner common.Address) (*big.Int, error) {
	return _AonUser.Contract.BalanceOf(&_AonUser.CallOpts, owner)
}

// BalanceOf is a free data retrieval call binding the contract method 0x70a08231.
//
// Solidity: function balanceOf(address owner) view returns(uint256 balance)
func (_AonUser *AonUserCallerSession) BalanceOf(owner common.Address) (*big.Int, error) {
	return _AonUser.Contract.BalanceOf(&_AonUser.CallOpts, owner)
}

// GetApproved is a free data retrieval call binding the contract method 0x081812fc.
//
// Solidity: function getApproved(uint256 tokenId) view returns(address operator)
func (_AonUser *AonUserCaller) GetApproved(opts *bind.CallOpts, tokenId *big.Int) (common.Address, error) {
	var out []interface{}
	err := _AonUser.contract.Call(opts, &out, "getApproved", tokenId)

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// GetApproved is a free data retrieval call binding the contract method 0x081812fc.
//
// Solidity: function getApproved(uint256 tokenId) view returns(address operator)
func (_AonUser *AonUserSession) GetApproved(tokenId *big.Int) (common.Address, error) {
	return _AonUser.Contract.GetApproved(&_AonUser.CallOpts, tokenId)
}

// GetApproved is a free data retrieval call binding the contract method 0x081812fc.
//
// Solidity: function getApproved(uint256 tokenId) view returns(address operator)
func (_AonUser *AonUserCallerSession) GetApproved(tokenId *big.Int) (common.Address, error) {
	return _AonUser.Contract.GetApproved(&_AonUser.CallOpts, tokenId)
}

// GetBalances is a free data retrieval call binding the contract method 0x08ad600e.
//
// Solidity: function getBalances(string _userId) view returns(string[] _symbols, string[] _names, uint256[] _balances)
func (_AonUser *AonUserCaller) GetBalances(opts *bind.CallOpts, _userId string) (struct {
	Symbols  []string
	Names    []string
	Balances []*big.Int
}, error) {
	var out []interface{}
	err := _AonUser.contract.Call(opts, &out, "getBalances", _userId)

	outstruct := new(struct {
		Symbols  []string
		Names    []string
		Balances []*big.Int
	})
	if err != nil {
		return *outstruct, err
	}

	outstruct.Symbols = *abi.ConvertType(out[0], new([]string)).(*[]string)
	outstruct.Names = *abi.ConvertType(out[1], new([]string)).(*[]string)
	outstruct.Balances = *abi.ConvertType(out[2], new([]*big.Int)).(*[]*big.Int)

	return *outstruct, err

}

// GetBalances is a free data retrieval call binding the contract method 0x08ad600e.
//
// Solidity: function getBalances(string _userId) view returns(string[] _symbols, string[] _names, uint256[] _balances)
func (_AonUser *AonUserSession) GetBalances(_userId string) (struct {
	Symbols  []string
	Names    []string
	Balances []*big.Int
}, error) {
	return _AonUser.Contract.GetBalances(&_AonUser.CallOpts, _userId)
}

// GetBalances is a free data retrieval call binding the contract method 0x08ad600e.
//
// Solidity: function getBalances(string _userId) view returns(string[] _symbols, string[] _names, uint256[] _balances)
func (_AonUser *AonUserCallerSession) GetBalances(_userId string) (struct {
	Symbols  []string
	Names    []string
	Balances []*big.Int
}, error) {
	return _AonUser.Contract.GetBalances(&_AonUser.CallOpts, _userId)
}

// GetOwnedUsers is a free data retrieval call binding the contract method 0x98d24e88.
//
// Solidity: function getOwnedUsers() view returns(string[] _userIds, string[] _userNames)
func (_AonUser *AonUserCaller) GetOwnedUsers(opts *bind.CallOpts) (struct {
	UserIds   []string
	UserNames []string
}, error) {
	var out []interface{}
	err := _AonUser.contract.Call(opts, &out, "getOwnedUsers")

	outstruct := new(struct {
		UserIds   []string
		UserNames []string
	})
	if err != nil {
		return *outstruct, err
	}

	outstruct.UserIds = *abi.ConvertType(out[0], new([]string)).(*[]string)
	outstruct.UserNames = *abi.ConvertType(out[1], new([]string)).(*[]string)

	return *outstruct, err

}

// GetOwnedUsers is a free data retrieval call binding the contract method 0x98d24e88.
//
// Solidity: function getOwnedUsers() view returns(string[] _userIds, string[] _userNames)
func (_AonUser *AonUserSession) GetOwnedUsers() (struct {
	UserIds   []string
	UserNames []string
}, error) {
	return _AonUser.Contract.GetOwnedUsers(&_AonUser.CallOpts)
}

// GetOwnedUsers is a free data retrieval call binding the contract method 0x98d24e88.
//
// Solidity: function getOwnedUsers() view returns(string[] _userIds, string[] _userNames)
func (_AonUser *AonUserCallerSession) GetOwnedUsers() (struct {
	UserIds   []string
	UserNames []string
}, error) {
	return _AonUser.Contract.GetOwnedUsers(&_AonUser.CallOpts)
}

// GetOwner is a free data retrieval call binding the contract method 0x4aaf4a12.
//
// Solidity: function getOwner(string _user) view returns(address)
func (_AonUser *AonUserCaller) GetOwner(opts *bind.CallOpts, _user string) (common.Address, error) {
	var out []interface{}
	err := _AonUser.contract.Call(opts, &out, "getOwner", _user)

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// GetOwner is a free data retrieval call binding the contract method 0x4aaf4a12.
//
// Solidity: function getOwner(string _user) view returns(address)
func (_AonUser *AonUserSession) GetOwner(_user string) (common.Address, error) {
	return _AonUser.Contract.GetOwner(&_AonUser.CallOpts, _user)
}

// GetOwner is a free data retrieval call binding the contract method 0x4aaf4a12.
//
// Solidity: function getOwner(string _user) view returns(address)
func (_AonUser *AonUserCallerSession) GetOwner(_user string) (common.Address, error) {
	return _AonUser.Contract.GetOwner(&_AonUser.CallOpts, _user)
}

// IsApprovedForAll is a free data retrieval call binding the contract method 0xe985e9c5.
//
// Solidity: function isApprovedForAll(address owner, address operator) view returns(bool)
func (_AonUser *AonUserCaller) IsApprovedForAll(opts *bind.CallOpts, owner common.Address, operator common.Address) (bool, error) {
	var out []interface{}
	err := _AonUser.contract.Call(opts, &out, "isApprovedForAll", owner, operator)

	if err != nil {
		return *new(bool), err
	}

	out0 := *abi.ConvertType(out[0], new(bool)).(*bool)

	return out0, err

}

// IsApprovedForAll is a free data retrieval call binding the contract method 0xe985e9c5.
//
// Solidity: function isApprovedForAll(address owner, address operator) view returns(bool)
func (_AonUser *AonUserSession) IsApprovedForAll(owner common.Address, operator common.Address) (bool, error) {
	return _AonUser.Contract.IsApprovedForAll(&_AonUser.CallOpts, owner, operator)
}

// IsApprovedForAll is a free data retrieval call binding the contract method 0xe985e9c5.
//
// Solidity: function isApprovedForAll(address owner, address operator) view returns(bool)
func (_AonUser *AonUserCallerSession) IsApprovedForAll(owner common.Address, operator common.Address) (bool, error) {
	return _AonUser.Contract.IsApprovedForAll(&_AonUser.CallOpts, owner, operator)
}

// Name is a free data retrieval call binding the contract method 0x06fdde03.
//
// Solidity: function name() view returns(string)
func (_AonUser *AonUserCaller) Name(opts *bind.CallOpts) (string, error) {
	var out []interface{}
	err := _AonUser.contract.Call(opts, &out, "name")

	if err != nil {
		return *new(string), err
	}

	out0 := *abi.ConvertType(out[0], new(string)).(*string)

	return out0, err

}

// Name is a free data retrieval call binding the contract method 0x06fdde03.
//
// Solidity: function name() view returns(string)
func (_AonUser *AonUserSession) Name() (string, error) {
	return _AonUser.Contract.Name(&_AonUser.CallOpts)
}

// Name is a free data retrieval call binding the contract method 0x06fdde03.
//
// Solidity: function name() view returns(string)
func (_AonUser *AonUserCallerSession) Name() (string, error) {
	return _AonUser.Contract.Name(&_AonUser.CallOpts)
}

// OwnerOf is a free data retrieval call binding the contract method 0x6352211e.
//
// Solidity: function ownerOf(uint256 tokenId) view returns(address owner)
func (_AonUser *AonUserCaller) OwnerOf(opts *bind.CallOpts, tokenId *big.Int) (common.Address, error) {
	var out []interface{}
	err := _AonUser.contract.Call(opts, &out, "ownerOf", tokenId)

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// OwnerOf is a free data retrieval call binding the contract method 0x6352211e.
//
// Solidity: function ownerOf(uint256 tokenId) view returns(address owner)
func (_AonUser *AonUserSession) OwnerOf(tokenId *big.Int) (common.Address, error) {
	return _AonUser.Contract.OwnerOf(&_AonUser.CallOpts, tokenId)
}

// OwnerOf is a free data retrieval call binding the contract method 0x6352211e.
//
// Solidity: function ownerOf(uint256 tokenId) view returns(address owner)
func (_AonUser *AonUserCallerSession) OwnerOf(tokenId *big.Int) (common.Address, error) {
	return _AonUser.Contract.OwnerOf(&_AonUser.CallOpts, tokenId)
}

// SupportsInterface is a free data retrieval call binding the contract method 0x01ffc9a7.
//
// Solidity: function supportsInterface(bytes4 interfaceId) view returns(bool)
func (_AonUser *AonUserCaller) SupportsInterface(opts *bind.CallOpts, interfaceId [4]byte) (bool, error) {
	var out []interface{}
	err := _AonUser.contract.Call(opts, &out, "supportsInterface", interfaceId)

	if err != nil {
		return *new(bool), err
	}

	out0 := *abi.ConvertType(out[0], new(bool)).(*bool)

	return out0, err

}

// SupportsInterface is a free data retrieval call binding the contract method 0x01ffc9a7.
//
// Solidity: function supportsInterface(bytes4 interfaceId) view returns(bool)
func (_AonUser *AonUserSession) SupportsInterface(interfaceId [4]byte) (bool, error) {
	return _AonUser.Contract.SupportsInterface(&_AonUser.CallOpts, interfaceId)
}

// SupportsInterface is a free data retrieval call binding the contract method 0x01ffc9a7.
//
// Solidity: function supportsInterface(bytes4 interfaceId) view returns(bool)
func (_AonUser *AonUserCallerSession) SupportsInterface(interfaceId [4]byte) (bool, error) {
	return _AonUser.Contract.SupportsInterface(&_AonUser.CallOpts, interfaceId)
}

// Symbol is a free data retrieval call binding the contract method 0x95d89b41.
//
// Solidity: function symbol() view returns(string)
func (_AonUser *AonUserCaller) Symbol(opts *bind.CallOpts) (string, error) {
	var out []interface{}
	err := _AonUser.contract.Call(opts, &out, "symbol")

	if err != nil {
		return *new(string), err
	}

	out0 := *abi.ConvertType(out[0], new(string)).(*string)

	return out0, err

}

// Symbol is a free data retrieval call binding the contract method 0x95d89b41.
//
// Solidity: function symbol() view returns(string)
func (_AonUser *AonUserSession) Symbol() (string, error) {
	return _AonUser.Contract.Symbol(&_AonUser.CallOpts)
}

// Symbol is a free data retrieval call binding the contract method 0x95d89b41.
//
// Solidity: function symbol() view returns(string)
func (_AonUser *AonUserCallerSession) Symbol() (string, error) {
	return _AonUser.Contract.Symbol(&_AonUser.CallOpts)
}

// TokenURI is a free data retrieval call binding the contract method 0xc87b56dd.
//
// Solidity: function tokenURI(uint256 tokenId) view returns(string)
func (_AonUser *AonUserCaller) TokenURI(opts *bind.CallOpts, tokenId *big.Int) (string, error) {
	var out []interface{}
	err := _AonUser.contract.Call(opts, &out, "tokenURI", tokenId)

	if err != nil {
		return *new(string), err
	}

	out0 := *abi.ConvertType(out[0], new(string)).(*string)

	return out0, err

}

// TokenURI is a free data retrieval call binding the contract method 0xc87b56dd.
//
// Solidity: function tokenURI(uint256 tokenId) view returns(string)
func (_AonUser *AonUserSession) TokenURI(tokenId *big.Int) (string, error) {
	return _AonUser.Contract.TokenURI(&_AonUser.CallOpts, tokenId)
}

// TokenURI is a free data retrieval call binding the contract method 0xc87b56dd.
//
// Solidity: function tokenURI(uint256 tokenId) view returns(string)
func (_AonUser *AonUserCallerSession) TokenURI(tokenId *big.Int) (string, error) {
	return _AonUser.Contract.TokenURI(&_AonUser.CallOpts, tokenId)
}

// UserIdToTokenId is a free data retrieval call binding the contract method 0x797cf053.
//
// Solidity: function userIdToTokenId(string _user) view returns(uint256)
func (_AonUser *AonUserCaller) UserIdToTokenId(opts *bind.CallOpts, _user string) (*big.Int, error) {
	var out []interface{}
	err := _AonUser.contract.Call(opts, &out, "userIdToTokenId", _user)

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// UserIdToTokenId is a free data retrieval call binding the contract method 0x797cf053.
//
// Solidity: function userIdToTokenId(string _user) view returns(uint256)
func (_AonUser *AonUserSession) UserIdToTokenId(_user string) (*big.Int, error) {
	return _AonUser.Contract.UserIdToTokenId(&_AonUser.CallOpts, _user)
}

// UserIdToTokenId is a free data retrieval call binding the contract method 0x797cf053.
//
// Solidity: function userIdToTokenId(string _user) view returns(uint256)
func (_AonUser *AonUserCallerSession) UserIdToTokenId(_user string) (*big.Int, error) {
	return _AonUser.Contract.UserIdToTokenId(&_AonUser.CallOpts, _user)
}

// UserInviter is a free data retrieval call binding the contract method 0x6690c3a1.
//
// Solidity: function userInviter(uint256 _user) view returns(uint256)
func (_AonUser *AonUserCaller) UserInviter(opts *bind.CallOpts, _user *big.Int) (*big.Int, error) {
	var out []interface{}
	err := _AonUser.contract.Call(opts, &out, "userInviter", _user)

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// UserInviter is a free data retrieval call binding the contract method 0x6690c3a1.
//
// Solidity: function userInviter(uint256 _user) view returns(uint256)
func (_AonUser *AonUserSession) UserInviter(_user *big.Int) (*big.Int, error) {
	return _AonUser.Contract.UserInviter(&_AonUser.CallOpts, _user)
}

// UserInviter is a free data retrieval call binding the contract method 0x6690c3a1.
//
// Solidity: function userInviter(uint256 _user) view returns(uint256)
func (_AonUser *AonUserCallerSession) UserInviter(_user *big.Int) (*big.Int, error) {
	return _AonUser.Contract.UserInviter(&_AonUser.CallOpts, _user)
}

// Approve is a paid mutator transaction binding the contract method 0x095ea7b3.
//
// Solidity: function approve(address to, uint256 tokenId) returns()
func (_AonUser *AonUserTransactor) Approve(opts *bind.TransactOpts, to common.Address, tokenId *big.Int) (*types.Transaction, error) {
	return _AonUser.contract.Transact(opts, "approve", to, tokenId)
}

// Approve is a paid mutator transaction binding the contract method 0x095ea7b3.
//
// Solidity: function approve(address to, uint256 tokenId) returns()
func (_AonUser *AonUserSession) Approve(to common.Address, tokenId *big.Int) (*types.Transaction, error) {
	return _AonUser.Contract.Approve(&_AonUser.TransactOpts, to, tokenId)
}

// Approve is a paid mutator transaction binding the contract method 0x095ea7b3.
//
// Solidity: function approve(address to, uint256 tokenId) returns()
func (_AonUser *AonUserTransactorSession) Approve(to common.Address, tokenId *big.Int) (*types.Transaction, error) {
	return _AonUser.Contract.Approve(&_AonUser.TransactOpts, to, tokenId)
}

// Login is a paid mutator transaction binding the contract method 0x58467dbc.
//
// Solidity: function login(string _userId, string _inviter) returns(bool)
func (_AonUser *AonUserTransactor) Login(opts *bind.TransactOpts, _userId string, _inviter string) (*types.Transaction, error) {
	return _AonUser.contract.Transact(opts, "login", _userId, _inviter)
}

// Login is a paid mutator transaction binding the contract method 0x58467dbc.
//
// Solidity: function login(string _userId, string _inviter) returns(bool)
func (_AonUser *AonUserSession) Login(_userId string, _inviter string) (*types.Transaction, error) {
	return _AonUser.Contract.Login(&_AonUser.TransactOpts, _userId, _inviter)
}

// Login is a paid mutator transaction binding the contract method 0x58467dbc.
//
// Solidity: function login(string _userId, string _inviter) returns(bool)
func (_AonUser *AonUserTransactorSession) Login(_userId string, _inviter string) (*types.Transaction, error) {
	return _AonUser.Contract.Login(&_AonUser.TransactOpts, _userId, _inviter)
}

// LoginByServer is a paid mutator transaction binding the contract method 0x4cf9284b.
//
// Solidity: function loginByServer(address _user, string _userId, string _inviter) returns(bool)
func (_AonUser *AonUserTransactor) LoginByServer(opts *bind.TransactOpts, _user common.Address, _userId string, _inviter string) (*types.Transaction, error) {
	return _AonUser.contract.Transact(opts, "loginByServer", _user, _userId, _inviter)
}

// LoginByServer is a paid mutator transaction binding the contract method 0x4cf9284b.
//
// Solidity: function loginByServer(address _user, string _userId, string _inviter) returns(bool)
func (_AonUser *AonUserSession) LoginByServer(_user common.Address, _userId string, _inviter string) (*types.Transaction, error) {
	return _AonUser.Contract.LoginByServer(&_AonUser.TransactOpts, _user, _userId, _inviter)
}

// LoginByServer is a paid mutator transaction binding the contract method 0x4cf9284b.
//
// Solidity: function loginByServer(address _user, string _userId, string _inviter) returns(bool)
func (_AonUser *AonUserTransactorSession) LoginByServer(_user common.Address, _userId string, _inviter string) (*types.Transaction, error) {
	return _AonUser.Contract.LoginByServer(&_AonUser.TransactOpts, _user, _userId, _inviter)
}

// SafeTransferFrom is a paid mutator transaction binding the contract method 0x42842e0e.
//
// Solidity: function safeTransferFrom(address from, address to, uint256 tokenId) returns()
func (_AonUser *AonUserTransactor) SafeTransferFrom(opts *bind.TransactOpts, from common.Address, to common.Address, tokenId *big.Int) (*types.Transaction, error) {
	return _AonUser.contract.Transact(opts, "safeTransferFrom", from, to, tokenId)
}

// SafeTransferFrom is a paid mutator transaction binding the contract method 0x42842e0e.
//
// Solidity: function safeTransferFrom(address from, address to, uint256 tokenId) returns()
func (_AonUser *AonUserSession) SafeTransferFrom(from common.Address, to common.Address, tokenId *big.Int) (*types.Transaction, error) {
	return _AonUser.Contract.SafeTransferFrom(&_AonUser.TransactOpts, from, to, tokenId)
}

// SafeTransferFrom is a paid mutator transaction binding the contract method 0x42842e0e.
//
// Solidity: function safeTransferFrom(address from, address to, uint256 tokenId) returns()
func (_AonUser *AonUserTransactorSession) SafeTransferFrom(from common.Address, to common.Address, tokenId *big.Int) (*types.Transaction, error) {
	return _AonUser.Contract.SafeTransferFrom(&_AonUser.TransactOpts, from, to, tokenId)
}

// SafeTransferFrom0 is a paid mutator transaction binding the contract method 0xb88d4fde.
//
// Solidity: function safeTransferFrom(address from, address to, uint256 tokenId, bytes data) returns()
func (_AonUser *AonUserTransactor) SafeTransferFrom0(opts *bind.TransactOpts, from common.Address, to common.Address, tokenId *big.Int, data []byte) (*types.Transaction, error) {
	return _AonUser.contract.Transact(opts, "safeTransferFrom0", from, to, tokenId, data)
}

// SafeTransferFrom0 is a paid mutator transaction binding the contract method 0xb88d4fde.
//
// Solidity: function safeTransferFrom(address from, address to, uint256 tokenId, bytes data) returns()
func (_AonUser *AonUserSession) SafeTransferFrom0(from common.Address, to common.Address, tokenId *big.Int, data []byte) (*types.Transaction, error) {
	return _AonUser.Contract.SafeTransferFrom0(&_AonUser.TransactOpts, from, to, tokenId, data)
}

// SafeTransferFrom0 is a paid mutator transaction binding the contract method 0xb88d4fde.
//
// Solidity: function safeTransferFrom(address from, address to, uint256 tokenId, bytes data) returns()
func (_AonUser *AonUserTransactorSession) SafeTransferFrom0(from common.Address, to common.Address, tokenId *big.Int, data []byte) (*types.Transaction, error) {
	return _AonUser.Contract.SafeTransferFrom0(&_AonUser.TransactOpts, from, to, tokenId, data)
}

// SetApprovalForAll is a paid mutator transaction binding the contract method 0xa22cb465.
//
// Solidity: function setApprovalForAll(address operator, bool approved) returns()
func (_AonUser *AonUserTransactor) SetApprovalForAll(opts *bind.TransactOpts, operator common.Address, approved bool) (*types.Transaction, error) {
	return _AonUser.contract.Transact(opts, "setApprovalForAll", operator, approved)
}

// SetApprovalForAll is a paid mutator transaction binding the contract method 0xa22cb465.
//
// Solidity: function setApprovalForAll(address operator, bool approved) returns()
func (_AonUser *AonUserSession) SetApprovalForAll(operator common.Address, approved bool) (*types.Transaction, error) {
	return _AonUser.Contract.SetApprovalForAll(&_AonUser.TransactOpts, operator, approved)
}

// SetApprovalForAll is a paid mutator transaction binding the contract method 0xa22cb465.
//
// Solidity: function setApprovalForAll(address operator, bool approved) returns()
func (_AonUser *AonUserTransactorSession) SetApprovalForAll(operator common.Address, approved bool) (*types.Transaction, error) {
	return _AonUser.Contract.SetApprovalForAll(&_AonUser.TransactOpts, operator, approved)
}

// TransferFrom is a paid mutator transaction binding the contract method 0x23b872dd.
//
// Solidity: function transferFrom(address from, address to, uint256 tokenId) returns()
func (_AonUser *AonUserTransactor) TransferFrom(opts *bind.TransactOpts, from common.Address, to common.Address, tokenId *big.Int) (*types.Transaction, error) {
	return _AonUser.contract.Transact(opts, "transferFrom", from, to, tokenId)
}

// TransferFrom is a paid mutator transaction binding the contract method 0x23b872dd.
//
// Solidity: function transferFrom(address from, address to, uint256 tokenId) returns()
func (_AonUser *AonUserSession) TransferFrom(from common.Address, to common.Address, tokenId *big.Int) (*types.Transaction, error) {
	return _AonUser.Contract.TransferFrom(&_AonUser.TransactOpts, from, to, tokenId)
}

// TransferFrom is a paid mutator transaction binding the contract method 0x23b872dd.
//
// Solidity: function transferFrom(address from, address to, uint256 tokenId) returns()
func (_AonUser *AonUserTransactorSession) TransferFrom(from common.Address, to common.Address, tokenId *big.Int) (*types.Transaction, error) {
	return _AonUser.Contract.TransferFrom(&_AonUser.TransactOpts, from, to, tokenId)
}

// AonUserApprovalIterator is returned from FilterApproval and is used to iterate over the raw logs and unpacked data for Approval events raised by the AonUser contract.
type AonUserApprovalIterator struct {
	Event *AonUserApproval // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *AonUserApprovalIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(AonUserApproval)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(AonUserApproval)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *AonUserApprovalIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *AonUserApprovalIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// AonUserApproval represents a Approval event raised by the AonUser contract.
type AonUserApproval struct {
	Owner    common.Address
	Approved common.Address
	TokenId  *big.Int
	Raw      types.Log // Blockchain specific contextual infos
}

// FilterApproval is a free log retrieval operation binding the contract event 0x8c5be1e5ebec7d5bd14f71427d1e84f3dd0314c0f7b2291e5b200ac8c7c3b925.
//
// Solidity: event Approval(address indexed owner, address indexed approved, uint256 indexed tokenId)
func (_AonUser *AonUserFilterer) FilterApproval(opts *bind.FilterOpts, owner []common.Address, approved []common.Address, tokenId []*big.Int) (*AonUserApprovalIterator, error) {

	var ownerRule []interface{}
	for _, ownerItem := range owner {
		ownerRule = append(ownerRule, ownerItem)
	}
	var approvedRule []interface{}
	for _, approvedItem := range approved {
		approvedRule = append(approvedRule, approvedItem)
	}
	var tokenIdRule []interface{}
	for _, tokenIdItem := range tokenId {
		tokenIdRule = append(tokenIdRule, tokenIdItem)
	}

	logs, sub, err := _AonUser.contract.FilterLogs(opts, "Approval", ownerRule, approvedRule, tokenIdRule)
	if err != nil {
		return nil, err
	}
	return &AonUserApprovalIterator{contract: _AonUser.contract, event: "Approval", logs: logs, sub: sub}, nil
}

// WatchApproval is a free log subscription operation binding the contract event 0x8c5be1e5ebec7d5bd14f71427d1e84f3dd0314c0f7b2291e5b200ac8c7c3b925.
//
// Solidity: event Approval(address indexed owner, address indexed approved, uint256 indexed tokenId)
func (_AonUser *AonUserFilterer) WatchApproval(opts *bind.WatchOpts, sink chan<- *AonUserApproval, owner []common.Address, approved []common.Address, tokenId []*big.Int) (event.Subscription, error) {

	var ownerRule []interface{}
	for _, ownerItem := range owner {
		ownerRule = append(ownerRule, ownerItem)
	}
	var approvedRule []interface{}
	for _, approvedItem := range approved {
		approvedRule = append(approvedRule, approvedItem)
	}
	var tokenIdRule []interface{}
	for _, tokenIdItem := range tokenId {
		tokenIdRule = append(tokenIdRule, tokenIdItem)
	}

	logs, sub, err := _AonUser.contract.WatchLogs(opts, "Approval", ownerRule, approvedRule, tokenIdRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(AonUserApproval)
				if err := _AonUser.contract.UnpackLog(event, "Approval", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseApproval is a log parse operation binding the contract event 0x8c5be1e5ebec7d5bd14f71427d1e84f3dd0314c0f7b2291e5b200ac8c7c3b925.
//
// Solidity: event Approval(address indexed owner, address indexed approved, uint256 indexed tokenId)
func (_AonUser *AonUserFilterer) ParseApproval(log types.Log) (*AonUserApproval, error) {
	event := new(AonUserApproval)
	if err := _AonUser.contract.UnpackLog(event, "Approval", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// AonUserApprovalForAllIterator is returned from FilterApprovalForAll and is used to iterate over the raw logs and unpacked data for ApprovalForAll events raised by the AonUser contract.
type AonUserApprovalForAllIterator struct {
	Event *AonUserApprovalForAll // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *AonUserApprovalForAllIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(AonUserApprovalForAll)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(AonUserApprovalForAll)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *AonUserApprovalForAllIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *AonUserApprovalForAllIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// AonUserApprovalForAll represents a ApprovalForAll event raised by the AonUser contract.
type AonUserApprovalForAll struct {
	Owner    common.Address
	Operator common.Address
	Approved bool
	Raw      types.Log // Blockchain specific contextual infos
}

// FilterApprovalForAll is a free log retrieval operation binding the contract event 0x17307eab39ab6107e8899845ad3d59bd9653f200f220920489ca2b5937696c31.
//
// Solidity: event ApprovalForAll(address indexed owner, address indexed operator, bool approved)
func (_AonUser *AonUserFilterer) FilterApprovalForAll(opts *bind.FilterOpts, owner []common.Address, operator []common.Address) (*AonUserApprovalForAllIterator, error) {

	var ownerRule []interface{}
	for _, ownerItem := range owner {
		ownerRule = append(ownerRule, ownerItem)
	}
	var operatorRule []interface{}
	for _, operatorItem := range operator {
		operatorRule = append(operatorRule, operatorItem)
	}

	logs, sub, err := _AonUser.contract.FilterLogs(opts, "ApprovalForAll", ownerRule, operatorRule)
	if err != nil {
		return nil, err
	}
	return &AonUserApprovalForAllIterator{contract: _AonUser.contract, event: "ApprovalForAll", logs: logs, sub: sub}, nil
}

// WatchApprovalForAll is a free log subscription operation binding the contract event 0x17307eab39ab6107e8899845ad3d59bd9653f200f220920489ca2b5937696c31.
//
// Solidity: event ApprovalForAll(address indexed owner, address indexed operator, bool approved)
func (_AonUser *AonUserFilterer) WatchApprovalForAll(opts *bind.WatchOpts, sink chan<- *AonUserApprovalForAll, owner []common.Address, operator []common.Address) (event.Subscription, error) {

	var ownerRule []interface{}
	for _, ownerItem := range owner {
		ownerRule = append(ownerRule, ownerItem)
	}
	var operatorRule []interface{}
	for _, operatorItem := range operator {
		operatorRule = append(operatorRule, operatorItem)
	}

	logs, sub, err := _AonUser.contract.WatchLogs(opts, "ApprovalForAll", ownerRule, operatorRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(AonUserApprovalForAll)
				if err := _AonUser.contract.UnpackLog(event, "ApprovalForAll", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseApprovalForAll is a log parse operation binding the contract event 0x17307eab39ab6107e8899845ad3d59bd9653f200f220920489ca2b5937696c31.
//
// Solidity: event ApprovalForAll(address indexed owner, address indexed operator, bool approved)
func (_AonUser *AonUserFilterer) ParseApprovalForAll(log types.Log) (*AonUserApprovalForAll, error) {
	event := new(AonUserApprovalForAll)
	if err := _AonUser.contract.UnpackLog(event, "ApprovalForAll", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// AonUserLoginIterator is returned from FilterLogin and is used to iterate over the raw logs and unpacked data for Login events raised by the AonUser contract.
type AonUserLoginIterator struct {
	Event *AonUserLogin // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *AonUserLoginIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(AonUserLogin)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(AonUserLogin)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *AonUserLoginIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *AonUserLoginIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// AonUserLogin represents a Login event raised by the AonUser contract.
type AonUserLogin struct {
	Addr      common.Address
	TokenId   *big.Int
	UserId    string
	LoginTime *big.Int
	Raw       types.Log // Blockchain specific contextual infos
}

// FilterLogin is a free log retrieval operation binding the contract event 0x73a80bd7c53c518474cf6f5cf50c31f68267a3bba9884c5f7f60e3cc7a2b1f50.
//
// Solidity: event Login(address indexed addr, uint256 indexed tokenId, string userId, uint256 loginTime)
func (_AonUser *AonUserFilterer) FilterLogin(opts *bind.FilterOpts, addr []common.Address, tokenId []*big.Int) (*AonUserLoginIterator, error) {

	var addrRule []interface{}
	for _, addrItem := range addr {
		addrRule = append(addrRule, addrItem)
	}
	var tokenIdRule []interface{}
	for _, tokenIdItem := range tokenId {
		tokenIdRule = append(tokenIdRule, tokenIdItem)
	}

	logs, sub, err := _AonUser.contract.FilterLogs(opts, "Login", addrRule, tokenIdRule)
	if err != nil {
		return nil, err
	}
	return &AonUserLoginIterator{contract: _AonUser.contract, event: "Login", logs: logs, sub: sub}, nil
}

// WatchLogin is a free log subscription operation binding the contract event 0x73a80bd7c53c518474cf6f5cf50c31f68267a3bba9884c5f7f60e3cc7a2b1f50.
//
// Solidity: event Login(address indexed addr, uint256 indexed tokenId, string userId, uint256 loginTime)
func (_AonUser *AonUserFilterer) WatchLogin(opts *bind.WatchOpts, sink chan<- *AonUserLogin, addr []common.Address, tokenId []*big.Int) (event.Subscription, error) {

	var addrRule []interface{}
	for _, addrItem := range addr {
		addrRule = append(addrRule, addrItem)
	}
	var tokenIdRule []interface{}
	for _, tokenIdItem := range tokenId {
		tokenIdRule = append(tokenIdRule, tokenIdItem)
	}

	logs, sub, err := _AonUser.contract.WatchLogs(opts, "Login", addrRule, tokenIdRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(AonUserLogin)
				if err := _AonUser.contract.UnpackLog(event, "Login", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseLogin is a log parse operation binding the contract event 0x73a80bd7c53c518474cf6f5cf50c31f68267a3bba9884c5f7f60e3cc7a2b1f50.
//
// Solidity: event Login(address indexed addr, uint256 indexed tokenId, string userId, uint256 loginTime)
func (_AonUser *AonUserFilterer) ParseLogin(log types.Log) (*AonUserLogin, error) {
	event := new(AonUserLogin)
	if err := _AonUser.contract.UnpackLog(event, "Login", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// AonUserRegisterIterator is returned from FilterRegister and is used to iterate over the raw logs and unpacked data for Register events raised by the AonUser contract.
type AonUserRegisterIterator struct {
	Event *AonUserRegister // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *AonUserRegisterIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(AonUserRegister)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(AonUserRegister)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *AonUserRegisterIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *AonUserRegisterIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// AonUserRegister represents a Register event raised by the AonUser contract.
type AonUserRegister struct {
	Addr         common.Address
	TokenId      *big.Int
	UserId       string
	UserInviter  string
	UserName     string
	RegisterTime *big.Int
	Raw          types.Log // Blockchain specific contextual infos
}

// FilterRegister is a free log retrieval operation binding the contract event 0x727986d2de20ed8f3e566563f137987e1ee5b6ffe929b8f9c05e3fe4216f1db8.
//
// Solidity: event Register(address indexed addr, uint256 indexed tokenId, string userId, string userInviter, string userName, uint256 registerTime)
func (_AonUser *AonUserFilterer) FilterRegister(opts *bind.FilterOpts, addr []common.Address, tokenId []*big.Int) (*AonUserRegisterIterator, error) {

	var addrRule []interface{}
	for _, addrItem := range addr {
		addrRule = append(addrRule, addrItem)
	}
	var tokenIdRule []interface{}
	for _, tokenIdItem := range tokenId {
		tokenIdRule = append(tokenIdRule, tokenIdItem)
	}

	logs, sub, err := _AonUser.contract.FilterLogs(opts, "Register", addrRule, tokenIdRule)
	if err != nil {
		return nil, err
	}
	return &AonUserRegisterIterator{contract: _AonUser.contract, event: "Register", logs: logs, sub: sub}, nil
}

// WatchRegister is a free log subscription operation binding the contract event 0x727986d2de20ed8f3e566563f137987e1ee5b6ffe929b8f9c05e3fe4216f1db8.
//
// Solidity: event Register(address indexed addr, uint256 indexed tokenId, string userId, string userInviter, string userName, uint256 registerTime)
func (_AonUser *AonUserFilterer) WatchRegister(opts *bind.WatchOpts, sink chan<- *AonUserRegister, addr []common.Address, tokenId []*big.Int) (event.Subscription, error) {

	var addrRule []interface{}
	for _, addrItem := range addr {
		addrRule = append(addrRule, addrItem)
	}
	var tokenIdRule []interface{}
	for _, tokenIdItem := range tokenId {
		tokenIdRule = append(tokenIdRule, tokenIdItem)
	}

	logs, sub, err := _AonUser.contract.WatchLogs(opts, "Register", addrRule, tokenIdRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(AonUserRegister)
				if err := _AonUser.contract.UnpackLog(event, "Register", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseRegister is a log parse operation binding the contract event 0x727986d2de20ed8f3e566563f137987e1ee5b6ffe929b8f9c05e3fe4216f1db8.
//
// Solidity: event Register(address indexed addr, uint256 indexed tokenId, string userId, string userInviter, string userName, uint256 registerTime)
func (_AonUser *AonUserFilterer) ParseRegister(log types.Log) (*AonUserRegister, error) {
	event := new(AonUserRegister)
	if err := _AonUser.contract.UnpackLog(event, "Register", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// AonUserTransferIterator is returned from FilterTransfer and is used to iterate over the raw logs and unpacked data for Transfer events raised by the AonUser contract.
type AonUserTransferIterator struct {
	Event *AonUserTransfer // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *AonUserTransferIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(AonUserTransfer)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(AonUserTransfer)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *AonUserTransferIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *AonUserTransferIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// AonUserTransfer represents a Transfer event raised by the AonUser contract.
type AonUserTransfer struct {
	From    common.Address
	To      common.Address
	TokenId *big.Int
	Raw     types.Log // Blockchain specific contextual infos
}

// FilterTransfer is a free log retrieval operation binding the contract event 0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef.
//
// Solidity: event Transfer(address indexed from, address indexed to, uint256 indexed tokenId)
func (_AonUser *AonUserFilterer) FilterTransfer(opts *bind.FilterOpts, from []common.Address, to []common.Address, tokenId []*big.Int) (*AonUserTransferIterator, error) {

	var fromRule []interface{}
	for _, fromItem := range from {
		fromRule = append(fromRule, fromItem)
	}
	var toRule []interface{}
	for _, toItem := range to {
		toRule = append(toRule, toItem)
	}
	var tokenIdRule []interface{}
	for _, tokenIdItem := range tokenId {
		tokenIdRule = append(tokenIdRule, tokenIdItem)
	}

	logs, sub, err := _AonUser.contract.FilterLogs(opts, "Transfer", fromRule, toRule, tokenIdRule)
	if err != nil {
		return nil, err
	}
	return &AonUserTransferIterator{contract: _AonUser.contract, event: "Transfer", logs: logs, sub: sub}, nil
}

// WatchTransfer is a free log subscription operation binding the contract event 0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef.
//
// Solidity: event Transfer(address indexed from, address indexed to, uint256 indexed tokenId)
func (_AonUser *AonUserFilterer) WatchTransfer(opts *bind.WatchOpts, sink chan<- *AonUserTransfer, from []common.Address, to []common.Address, tokenId []*big.Int) (event.Subscription, error) {

	var fromRule []interface{}
	for _, fromItem := range from {
		fromRule = append(fromRule, fromItem)
	}
	var toRule []interface{}
	for _, toItem := range to {
		toRule = append(toRule, toItem)
	}
	var tokenIdRule []interface{}
	for _, tokenIdItem := range tokenId {
		tokenIdRule = append(tokenIdRule, tokenIdItem)
	}

	logs, sub, err := _AonUser.contract.WatchLogs(opts, "Transfer", fromRule, toRule, tokenIdRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(AonUserTransfer)
				if err := _AonUser.contract.UnpackLog(event, "Transfer", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseTransfer is a log parse operation binding the contract event 0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef.
//
// Solidity: event Transfer(address indexed from, address indexed to, uint256 indexed tokenId)
func (_AonUser *AonUserFilterer) ParseTransfer(log types.Log) (*AonUserTransfer, error) {
	event := new(AonUserTransfer)
	if err := _AonUser.contract.UnpackLog(event, "Transfer", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}
